// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.FileSystemConverter))]
public sealed partial class FileSystem
{
#if NET7_0_OR_GREATER
	public FileSystem()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FileSystem()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FileSystem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// List of all file stores.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.DataPathStats>? Data { get; set; }

	/// <summary>
	/// <para>
	/// Contains I/O statistics for the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.IoStats? IoStats { get; set; }

	/// <summary>
	/// <para>
	/// Last time the file stores statistics were refreshed.
	/// Recorded in milliseconds since the Unix Epoch.
	/// </para>
	/// </summary>
	public long? Timestamp { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics for all file stores of the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.FileSystemTotal? Total { get; set; }
}