// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.ExtendedMemoryStatsConverter))]
public sealed partial class ExtendedMemoryStats
{
#if NET7_0_OR_GREATER
	public ExtendedMemoryStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ExtendedMemoryStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ExtendedMemoryStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If the amount of physical memory has been overridden using the <c>es</c>.<c>total_memory_bytes</c> system property then this reports the overridden value in bytes.
	/// Otherwise it reports the same value as <c>total_in_bytes</c>.
	/// </para>
	/// </summary>
	public long? AdjustedTotalInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Amount of free physical memory in bytes.
	/// </para>
	/// </summary>
	public long? FreeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Percentage of free memory.
	/// </para>
	/// </summary>
	public int? FreePercent { get; set; }
	public string? Resident { get; set; }
	public long? ResidentInBytes { get; set; }
	public string? Share { get; set; }
	public long? ShareInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of physical memory in bytes.
	/// </para>
	/// </summary>
	public long? TotalInBytes { get; set; }
	public string? TotalVirtual { get; set; }
	public long? TotalVirtualInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Amount of used physical memory in bytes.
	/// </para>
	/// </summary>
	public long? UsedInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Percentage of used memory.
	/// </para>
	/// </summary>
	public int? UsedPercent { get; set; }
}