// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.DiscoveryConverter))]
public sealed partial class Discovery
{
#if NET7_0_OR_GREATER
	public Discovery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Discovery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Discovery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Nodes.ClusterAppliedStats? ClusterApplierStats { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics for the cluster state queue of the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.ClusterStateQueue? ClusterStateQueue { get; set; }

	/// <summary>
	/// <para>
	/// Contains low-level statistics about how long various activities took during cluster state updates while the node was the elected master.
	/// Omitted if the node is not master-eligible.
	/// Every field whose name ends in <c>_time</c> within this object is also represented as a raw number of milliseconds in a field whose name ends in <c>_time_millis</c>.
	/// The human-readable fields with a <c>_time</c> suffix are only returned if requested with the <c>?human=true</c> query parameter.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.ClusterStateUpdate>? ClusterStateUpdate { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics for the published cluster states of the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.PublishedClusterStates? PublishedClusterStates { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.SerializedClusterState? SerializedClusterStates { get; set; }
}