// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.DataPathStatsConverter))]
public sealed partial class DataPathStats
{
#if NET7_0_OR_GREATER
	public DataPathStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataPathStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataPathStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total amount of disk space available to this Java virtual machine on this file store.
	/// </para>
	/// </summary>
	public string? Available { get; set; }

	/// <summary>
	/// <para>
	/// Total number of bytes available to this Java virtual machine on this file store.
	/// </para>
	/// </summary>
	public long? AvailableInBytes { get; set; }
	public string? DiskQueue { get; set; }
	public long? DiskReads { get; set; }
	public string? DiskReadSize { get; set; }
	public long? DiskReadSizeInBytes { get; set; }
	public long? DiskWrites { get; set; }
	public string? DiskWriteSize { get; set; }
	public long? DiskWriteSizeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of unallocated disk space in the file store.
	/// </para>
	/// </summary>
	public string? Free { get; set; }

	/// <summary>
	/// <para>
	/// Total number of unallocated bytes in the file store.
	/// </para>
	/// </summary>
	public long? FreeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Mount point of the file store (for example: <c>/dev/sda2</c>).
	/// </para>
	/// </summary>
	public string? Mount { get; set; }

	/// <summary>
	/// <para>
	/// Path to the file store.
	/// </para>
	/// </summary>
	public string? Path { get; set; }

	/// <summary>
	/// <para>
	/// Total size of the file store.
	/// </para>
	/// </summary>
	public string? Total { get; set; }

	/// <summary>
	/// <para>
	/// Total size of the file store in bytes.
	/// </para>
	/// </summary>
	public long? TotalInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Type of the file store (ex: ext4).
	/// </para>
	/// </summary>
	public string? Type { get; set; }
}