// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class DataPathStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.DataPathStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAvailable = System.Text.Json.JsonEncodedText.Encode("available");
	private static readonly System.Text.Json.JsonEncodedText PropAvailableInBytes = System.Text.Json.JsonEncodedText.Encode("available_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropDiskQueue = System.Text.Json.JsonEncodedText.Encode("disk_queue");
	private static readonly System.Text.Json.JsonEncodedText PropDiskReads = System.Text.Json.JsonEncodedText.Encode("disk_reads");
	private static readonly System.Text.Json.JsonEncodedText PropDiskReadSize = System.Text.Json.JsonEncodedText.Encode("disk_read_size");
	private static readonly System.Text.Json.JsonEncodedText PropDiskReadSizeInBytes = System.Text.Json.JsonEncodedText.Encode("disk_read_size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropDiskWrites = System.Text.Json.JsonEncodedText.Encode("disk_writes");
	private static readonly System.Text.Json.JsonEncodedText PropDiskWriteSize = System.Text.Json.JsonEncodedText.Encode("disk_write_size");
	private static readonly System.Text.Json.JsonEncodedText PropDiskWriteSizeInBytes = System.Text.Json.JsonEncodedText.Encode("disk_write_size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropFree = System.Text.Json.JsonEncodedText.Encode("free");
	private static readonly System.Text.Json.JsonEncodedText PropFreeInBytes = System.Text.Json.JsonEncodedText.Encode("free_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropMount = System.Text.Json.JsonEncodedText.Encode("mount");
	private static readonly System.Text.Json.JsonEncodedText PropPath = System.Text.Json.JsonEncodedText.Encode("path");
	private static readonly System.Text.Json.JsonEncodedText PropTotal = System.Text.Json.JsonEncodedText.Encode("total");
	private static readonly System.Text.Json.JsonEncodedText PropTotalInBytes = System.Text.Json.JsonEncodedText.Encode("total_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");

	public override Elastic.Clients.Elasticsearch.Nodes.DataPathStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propAvailable = default;
		LocalJsonValue<long?> propAvailableInBytes = default;
		LocalJsonValue<string?> propDiskQueue = default;
		LocalJsonValue<long?> propDiskReads = default;
		LocalJsonValue<string?> propDiskReadSize = default;
		LocalJsonValue<long?> propDiskReadSizeInBytes = default;
		LocalJsonValue<long?> propDiskWrites = default;
		LocalJsonValue<string?> propDiskWriteSize = default;
		LocalJsonValue<long?> propDiskWriteSizeInBytes = default;
		LocalJsonValue<string?> propFree = default;
		LocalJsonValue<long?> propFreeInBytes = default;
		LocalJsonValue<string?> propMount = default;
		LocalJsonValue<string?> propPath = default;
		LocalJsonValue<string?> propTotal = default;
		LocalJsonValue<long?> propTotalInBytes = default;
		LocalJsonValue<string?> propType = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAvailable.TryReadProperty(ref reader, options, PropAvailable, null))
			{
				continue;
			}

			if (propAvailableInBytes.TryReadProperty(ref reader, options, PropAvailableInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propDiskQueue.TryReadProperty(ref reader, options, PropDiskQueue, null))
			{
				continue;
			}

			if (propDiskReads.TryReadProperty(ref reader, options, PropDiskReads, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propDiskReadSize.TryReadProperty(ref reader, options, PropDiskReadSize, null))
			{
				continue;
			}

			if (propDiskReadSizeInBytes.TryReadProperty(ref reader, options, PropDiskReadSizeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propDiskWrites.TryReadProperty(ref reader, options, PropDiskWrites, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propDiskWriteSize.TryReadProperty(ref reader, options, PropDiskWriteSize, null))
			{
				continue;
			}

			if (propDiskWriteSizeInBytes.TryReadProperty(ref reader, options, PropDiskWriteSizeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propFree.TryReadProperty(ref reader, options, PropFree, null))
			{
				continue;
			}

			if (propFreeInBytes.TryReadProperty(ref reader, options, PropFreeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propMount.TryReadProperty(ref reader, options, PropMount, null))
			{
				continue;
			}

			if (propPath.TryReadProperty(ref reader, options, PropPath, null))
			{
				continue;
			}

			if (propTotal.TryReadProperty(ref reader, options, PropTotal, null))
			{
				continue;
			}

			if (propTotalInBytes.TryReadProperty(ref reader, options, PropTotalInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propType.TryReadProperty(ref reader, options, PropType, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.DataPathStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Available = propAvailable.Value,
			AvailableInBytes = propAvailableInBytes.Value,
			DiskQueue = propDiskQueue.Value,
			DiskReads = propDiskReads.Value,
			DiskReadSize = propDiskReadSize.Value,
			DiskReadSizeInBytes = propDiskReadSizeInBytes.Value,
			DiskWrites = propDiskWrites.Value,
			DiskWriteSize = propDiskWriteSize.Value,
			DiskWriteSizeInBytes = propDiskWriteSizeInBytes.Value,
			Free = propFree.Value,
			FreeInBytes = propFreeInBytes.Value,
			Mount = propMount.Value,
			Path = propPath.Value,
			Total = propTotal.Value,
			TotalInBytes = propTotalInBytes.Value,
			Type = propType.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.DataPathStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAvailable, value.Available, null, null);
		writer.WriteProperty(options, PropAvailableInBytes, value.AvailableInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropDiskQueue, value.DiskQueue, null, null);
		writer.WriteProperty(options, PropDiskReads, value.DiskReads, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropDiskReadSize, value.DiskReadSize, null, null);
		writer.WriteProperty(options, PropDiskReadSizeInBytes, value.DiskReadSizeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropDiskWrites, value.DiskWrites, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropDiskWriteSize, value.DiskWriteSize, null, null);
		writer.WriteProperty(options, PropDiskWriteSizeInBytes, value.DiskWriteSizeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropFree, value.Free, null, null);
		writer.WriteProperty(options, PropFreeInBytes, value.FreeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropMount, value.Mount, null, null);
		writer.WriteProperty(options, PropPath, value.Path, null, null);
		writer.WriteProperty(options, PropTotal, value.Total, null, null);
		writer.WriteProperty(options, PropTotalInBytes, value.TotalInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropType, value.Type, null, null);
		writer.WriteEndObject();
	}
}