// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.ClientConverter))]
public sealed partial class Client
{
#if NET7_0_OR_GREATER
	public Client()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Client()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Client(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Reported agent for the HTTP client.
	/// If unavailable, this property is not included in the response.
	/// </para>
	/// </summary>
	public string? Agent { get; set; }

	/// <summary>
	/// <para>
	/// Time at which the client closed the connection if the connection is closed.
	/// </para>
	/// </summary>
	public long? ClosedTimeMillis { get; set; }

	/// <summary>
	/// <para>
	/// Unique ID for the HTTP client.
	/// </para>
	/// </summary>
	public long? Id { get; set; }

	/// <summary>
	/// <para>
	/// Time of the most recent request from this client.
	/// </para>
	/// </summary>
	public long? LastRequestTimeMillis { get; set; }

	/// <summary>
	/// <para>
	/// The URI of the client’s most recent request.
	/// </para>
	/// </summary>
	public string? LastUri { get; set; }

	/// <summary>
	/// <para>
	/// Local address for the HTTP connection.
	/// </para>
	/// </summary>
	public string? LocalAddress { get; set; }

	/// <summary>
	/// <para>
	/// Time at which the client opened the connection.
	/// </para>
	/// </summary>
	public long? OpenedTimeMillis { get; set; }

	/// <summary>
	/// <para>
	/// Remote address for the HTTP connection.
	/// </para>
	/// </summary>
	public string? RemoteAddress { get; set; }

	/// <summary>
	/// <para>
	/// Number of requests from this client.
	/// </para>
	/// </summary>
	public long? RequestCount { get; set; }

	/// <summary>
	/// <para>
	/// Cumulative size in bytes of all requests from this client.
	/// </para>
	/// </summary>
	public long? RequestSizeBytes { get; set; }

	/// <summary>
	/// <para>
	/// Value from the client’s <c>x-opaque-id</c> HTTP header.
	/// If unavailable, this property is not included in the response.
	/// </para>
	/// </summary>
	public string? XOpaqueId { get; set; }
}