// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class ClientConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.Client>
{
	private static readonly System.Text.Json.JsonEncodedText PropAgent = System.Text.Json.JsonEncodedText.Encode("agent");
	private static readonly System.Text.Json.JsonEncodedText PropClosedTimeMillis = System.Text.Json.JsonEncodedText.Encode("closed_time_millis");
	private static readonly System.Text.Json.JsonEncodedText PropId = System.Text.Json.JsonEncodedText.Encode("id");
	private static readonly System.Text.Json.JsonEncodedText PropLastRequestTimeMillis = System.Text.Json.JsonEncodedText.Encode("last_request_time_millis");
	private static readonly System.Text.Json.JsonEncodedText PropLastUri = System.Text.Json.JsonEncodedText.Encode("last_uri");
	private static readonly System.Text.Json.JsonEncodedText PropLocalAddress = System.Text.Json.JsonEncodedText.Encode("local_address");
	private static readonly System.Text.Json.JsonEncodedText PropOpenedTimeMillis = System.Text.Json.JsonEncodedText.Encode("opened_time_millis");
	private static readonly System.Text.Json.JsonEncodedText PropRemoteAddress = System.Text.Json.JsonEncodedText.Encode("remote_address");
	private static readonly System.Text.Json.JsonEncodedText PropRequestCount = System.Text.Json.JsonEncodedText.Encode("request_count");
	private static readonly System.Text.Json.JsonEncodedText PropRequestSizeBytes = System.Text.Json.JsonEncodedText.Encode("request_size_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropXOpaqueId = System.Text.Json.JsonEncodedText.Encode("x_opaque_id");

	public override Elastic.Clients.Elasticsearch.Nodes.Client Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propAgent = default;
		LocalJsonValue<long?> propClosedTimeMillis = default;
		LocalJsonValue<long?> propId = default;
		LocalJsonValue<long?> propLastRequestTimeMillis = default;
		LocalJsonValue<string?> propLastUri = default;
		LocalJsonValue<string?> propLocalAddress = default;
		LocalJsonValue<long?> propOpenedTimeMillis = default;
		LocalJsonValue<string?> propRemoteAddress = default;
		LocalJsonValue<long?> propRequestCount = default;
		LocalJsonValue<long?> propRequestSizeBytes = default;
		LocalJsonValue<string?> propXOpaqueId = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAgent.TryReadProperty(ref reader, options, PropAgent, null))
			{
				continue;
			}

			if (propClosedTimeMillis.TryReadProperty(ref reader, options, PropClosedTimeMillis, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propId.TryReadProperty(ref reader, options, PropId, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propLastRequestTimeMillis.TryReadProperty(ref reader, options, PropLastRequestTimeMillis, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propLastUri.TryReadProperty(ref reader, options, PropLastUri, null))
			{
				continue;
			}

			if (propLocalAddress.TryReadProperty(ref reader, options, PropLocalAddress, null))
			{
				continue;
			}

			if (propOpenedTimeMillis.TryReadProperty(ref reader, options, PropOpenedTimeMillis, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propRemoteAddress.TryReadProperty(ref reader, options, PropRemoteAddress, null))
			{
				continue;
			}

			if (propRequestCount.TryReadProperty(ref reader, options, PropRequestCount, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propRequestSizeBytes.TryReadProperty(ref reader, options, PropRequestSizeBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propXOpaqueId.TryReadProperty(ref reader, options, PropXOpaqueId, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.Client(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Agent = propAgent.Value,
			ClosedTimeMillis = propClosedTimeMillis.Value,
			Id = propId.Value,
			LastRequestTimeMillis = propLastRequestTimeMillis.Value,
			LastUri = propLastUri.Value,
			LocalAddress = propLocalAddress.Value,
			OpenedTimeMillis = propOpenedTimeMillis.Value,
			RemoteAddress = propRemoteAddress.Value,
			RequestCount = propRequestCount.Value,
			RequestSizeBytes = propRequestSizeBytes.Value,
			XOpaqueId = propXOpaqueId.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.Client value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAgent, value.Agent, null, null);
		writer.WriteProperty(options, PropClosedTimeMillis, value.ClosedTimeMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropId, value.Id, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropLastRequestTimeMillis, value.LastRequestTimeMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropLastUri, value.LastUri, null, null);
		writer.WriteProperty(options, PropLocalAddress, value.LocalAddress, null, null);
		writer.WriteProperty(options, PropOpenedTimeMillis, value.OpenedTimeMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropRemoteAddress, value.RemoteAddress, null, null);
		writer.WriteProperty(options, PropRequestCount, value.RequestCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropRequestSizeBytes, value.RequestSizeBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropXOpaqueId, value.XOpaqueId, null, null);
		writer.WriteEndObject();
	}
}