// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.CgroupMemoryConverter))]
public sealed partial class CgroupMemory
{
#if NET7_0_OR_GREATER
	public CgroupMemory()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CgroupMemory()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CgroupMemory(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The <c>memory</c> control group to which the Elasticsearch process belongs.
	/// </para>
	/// </summary>
	public string? ControlGroup { get; set; }

	/// <summary>
	/// <para>
	/// The maximum amount of user memory (including file cache) allowed for all tasks in the same cgroup as the Elasticsearch process.
	/// This value can be too big to store in a <c>long</c>, so is returned as a string so that the value returned can exactly match what the underlying operating system interface returns.
	/// Any value that is too large to parse into a <c>long</c> almost certainly means no limit has been set for the cgroup.
	/// </para>
	/// </summary>
	public string? LimitInBytes { get; set; }

	/// <summary>
	/// <para>
	/// The total current memory usage by processes in the cgroup, in bytes, by all tasks in the same cgroup as the Elasticsearch process.
	/// This value is stored as a string for consistency with <c>limit_in_bytes</c>.
	/// </para>
	/// </summary>
	public string? UsageInBytes { get; set; }
}