// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.CgroupCpuConverter))]
public sealed partial class CgroupCpu
{
#if NET7_0_OR_GREATER
	public CgroupCpu()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CgroupCpu()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CgroupCpu(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The period of time, in microseconds, for how regularly all tasks in the same cgroup as the Elasticsearch process should have their access to CPU resources reallocated.
	/// </para>
	/// </summary>
	public int? CfsPeriodMicros { get; set; }

	/// <summary>
	/// <para>
	/// The total amount of time, in microseconds, for which all tasks in the same cgroup as the Elasticsearch process can run during one period <c>cfs_period_micros</c>.
	/// </para>
	/// </summary>
	public int? CfsQuotaMicros { get; set; }

	/// <summary>
	/// <para>
	/// The <c>cpu</c> control group to which the Elasticsearch process belongs.
	/// </para>
	/// </summary>
	public string? ControlGroup { get; set; }

	/// <summary>
	/// <para>
	/// Contains CPU statistics for the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.CgroupCpuStat? Stat { get; set; }
}