// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class CgroupCpuConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.CgroupCpu>
{
	private static readonly System.Text.Json.JsonEncodedText PropCfsPeriodMicros = System.Text.Json.JsonEncodedText.Encode("cfs_period_micros");
	private static readonly System.Text.Json.JsonEncodedText PropCfsQuotaMicros = System.Text.Json.JsonEncodedText.Encode("cfs_quota_micros");
	private static readonly System.Text.Json.JsonEncodedText PropControlGroup = System.Text.Json.JsonEncodedText.Encode("control_group");
	private static readonly System.Text.Json.JsonEncodedText PropStat = System.Text.Json.JsonEncodedText.Encode("stat");

	public override Elastic.Clients.Elasticsearch.Nodes.CgroupCpu Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int?> propCfsPeriodMicros = default;
		LocalJsonValue<int?> propCfsQuotaMicros = default;
		LocalJsonValue<string?> propControlGroup = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.CgroupCpuStat?> propStat = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCfsPeriodMicros.TryReadProperty(ref reader, options, PropCfsPeriodMicros, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propCfsQuotaMicros.TryReadProperty(ref reader, options, PropCfsQuotaMicros, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propControlGroup.TryReadProperty(ref reader, options, PropControlGroup, null))
			{
				continue;
			}

			if (propStat.TryReadProperty(ref reader, options, PropStat, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.CgroupCpu(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			CfsPeriodMicros = propCfsPeriodMicros.Value,
			CfsQuotaMicros = propCfsQuotaMicros.Value,
			ControlGroup = propControlGroup.Value,
			Stat = propStat.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.CgroupCpu value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCfsPeriodMicros, value.CfsPeriodMicros, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropCfsQuotaMicros, value.CfsQuotaMicros, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropControlGroup, value.ControlGroup, null, null);
		writer.WriteProperty(options, PropStat, value.Stat, null, null);
		writer.WriteEndObject();
	}
}