// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.BreakerConverter))]
public sealed partial class Breaker
{
#if NET7_0_OR_GREATER
	public Breaker()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Breaker()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Breaker(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Estimated memory used for the operation.
	/// </para>
	/// </summary>
	public string? EstimatedSize { get; set; }

	/// <summary>
	/// <para>
	/// Estimated memory used, in bytes, for the operation.
	/// </para>
	/// </summary>
	public long? EstimatedSizeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Memory limit for the circuit breaker.
	/// </para>
	/// </summary>
	public string? LimitSize { get; set; }

	/// <summary>
	/// <para>
	/// Memory limit, in bytes, for the circuit breaker.
	/// </para>
	/// </summary>
	public long? LimitSizeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// A constant that all estimates for the circuit breaker are multiplied with to calculate a final estimate.
	/// </para>
	/// </summary>
	public float? Overhead { get; set; }

	/// <summary>
	/// <para>
	/// Total number of times the circuit breaker has been triggered and prevented an out of memory error.
	/// </para>
	/// </summary>
	public float? Tripped { get; set; }
}