// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.AdaptiveSelectionConverter))]
public sealed partial class AdaptiveSelection
{
#if NET7_0_OR_GREATER
	public AdaptiveSelection()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AdaptiveSelection()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AdaptiveSelection(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The exponentially weighted moving average queue size of search requests on the keyed node.
	/// </para>
	/// </summary>
	public long? AvgQueueSize { get; set; }

	/// <summary>
	/// <para>
	/// The exponentially weighted moving average response time of search requests on the keyed node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? AvgResponseTime { get; set; }

	/// <summary>
	/// <para>
	/// The exponentially weighted moving average response time, in nanoseconds, of search requests on the keyed node.
	/// </para>
	/// </summary>
	public long? AvgResponseTimeNs { get; set; }

	/// <summary>
	/// <para>
	/// The exponentially weighted moving average service time of search requests on the keyed node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? AvgServiceTime { get; set; }

	/// <summary>
	/// <para>
	/// The exponentially weighted moving average service time, in nanoseconds, of search requests on the keyed node.
	/// </para>
	/// </summary>
	public long? AvgServiceTimeNs { get; set; }

	/// <summary>
	/// <para>
	/// The number of outstanding search requests to the keyed node from the node these stats are for.
	/// </para>
	/// </summary>
	public long? OutgoingSearches { get; set; }

	/// <summary>
	/// <para>
	/// The rank of this node; used for shard selection when routing search requests.
	/// </para>
	/// </summary>
	public string? Rank { get; set; }
}