// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class AdaptiveSelectionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection>
{
	private static readonly System.Text.Json.JsonEncodedText PropAvgQueueSize = System.Text.Json.JsonEncodedText.Encode("avg_queue_size");
	private static readonly System.Text.Json.JsonEncodedText PropAvgResponseTime = System.Text.Json.JsonEncodedText.Encode("avg_response_time");
	private static readonly System.Text.Json.JsonEncodedText PropAvgResponseTimeNs = System.Text.Json.JsonEncodedText.Encode("avg_response_time_ns");
	private static readonly System.Text.Json.JsonEncodedText PropAvgServiceTime = System.Text.Json.JsonEncodedText.Encode("avg_service_time");
	private static readonly System.Text.Json.JsonEncodedText PropAvgServiceTimeNs = System.Text.Json.JsonEncodedText.Encode("avg_service_time_ns");
	private static readonly System.Text.Json.JsonEncodedText PropOutgoingSearches = System.Text.Json.JsonEncodedText.Encode("outgoing_searches");
	private static readonly System.Text.Json.JsonEncodedText PropRank = System.Text.Json.JsonEncodedText.Encode("rank");

	public override Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long?> propAvgQueueSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propAvgResponseTime = default;
		LocalJsonValue<long?> propAvgResponseTimeNs = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propAvgServiceTime = default;
		LocalJsonValue<long?> propAvgServiceTimeNs = default;
		LocalJsonValue<long?> propOutgoingSearches = default;
		LocalJsonValue<string?> propRank = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAvgQueueSize.TryReadProperty(ref reader, options, PropAvgQueueSize, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propAvgResponseTime.TryReadProperty(ref reader, options, PropAvgResponseTime, null))
			{
				continue;
			}

			if (propAvgResponseTimeNs.TryReadProperty(ref reader, options, PropAvgResponseTimeNs, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propAvgServiceTime.TryReadProperty(ref reader, options, PropAvgServiceTime, null))
			{
				continue;
			}

			if (propAvgServiceTimeNs.TryReadProperty(ref reader, options, PropAvgServiceTimeNs, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propOutgoingSearches.TryReadProperty(ref reader, options, PropOutgoingSearches, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propRank.TryReadProperty(ref reader, options, PropRank, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AvgQueueSize = propAvgQueueSize.Value,
			AvgResponseTime = propAvgResponseTime.Value,
			AvgResponseTimeNs = propAvgResponseTimeNs.Value,
			AvgServiceTime = propAvgServiceTime.Value,
			AvgServiceTimeNs = propAvgServiceTimeNs.Value,
			OutgoingSearches = propOutgoingSearches.Value,
			Rank = propRank.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAvgQueueSize, value.AvgQueueSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropAvgResponseTime, value.AvgResponseTime, null, null);
		writer.WriteProperty(options, PropAvgResponseTimeNs, value.AvgResponseTimeNs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropAvgServiceTime, value.AvgServiceTime, null, null);
		writer.WriteProperty(options, PropAvgServiceTimeNs, value.AvgServiceTimeNs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropOutgoingSearches, value.OutgoingSearches, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropRank, value.Rank, null, null);
		writer.WriteEndObject();
	}
}