// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class NodeShardConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.NodeShard>
{
	private static readonly System.Text.Json.JsonEncodedText PropAllocationId = System.Text.Json.JsonEncodedText.Encode("allocation_id");
	private static readonly System.Text.Json.JsonEncodedText PropIndex = System.Text.Json.JsonEncodedText.Encode("index");
	private static readonly System.Text.Json.JsonEncodedText PropNode = System.Text.Json.JsonEncodedText.Encode("node");
	private static readonly System.Text.Json.JsonEncodedText PropPrimary = System.Text.Json.JsonEncodedText.Encode("primary");
	private static readonly System.Text.Json.JsonEncodedText PropRecoverySource = System.Text.Json.JsonEncodedText.Encode("recovery_source");
	private static readonly System.Text.Json.JsonEncodedText PropRelocatingNode = System.Text.Json.JsonEncodedText.Encode("relocating_node");
	private static readonly System.Text.Json.JsonEncodedText PropRelocationFailureInfo = System.Text.Json.JsonEncodedText.Encode("relocation_failure_info");
	private static readonly System.Text.Json.JsonEncodedText PropShard = System.Text.Json.JsonEncodedText.Encode("shard");
	private static readonly System.Text.Json.JsonEncodedText PropState = System.Text.Json.JsonEncodedText.Encode("state");
	private static readonly System.Text.Json.JsonEncodedText PropUnassignedInfo = System.Text.Json.JsonEncodedText.Encode("unassigned_info");

	public override Elastic.Clients.Elasticsearch.NodeShard Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, string>?> propAllocationId = default;
		LocalJsonValue<string> propIndex = default;
		LocalJsonValue<string?> propNode = default;
		LocalJsonValue<bool> propPrimary = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, string>?> propRecoverySource = default;
		LocalJsonValue<string?> propRelocatingNode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.RelocationFailureInfo?> propRelocationFailureInfo = default;
		LocalJsonValue<int> propShard = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState> propState = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.UnassignedInformation?> propUnassignedInfo = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAllocationId.TryReadProperty(ref reader, options, PropAllocationId, static System.Collections.Generic.IReadOnlyDictionary<string, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, string>(o, null, null)))
			{
				continue;
			}

			if (propIndex.TryReadProperty(ref reader, options, PropIndex, null))
			{
				continue;
			}

			if (propNode.TryReadProperty(ref reader, options, PropNode, null))
			{
				continue;
			}

			if (propPrimary.TryReadProperty(ref reader, options, PropPrimary, null))
			{
				continue;
			}

			if (propRecoverySource.TryReadProperty(ref reader, options, PropRecoverySource, static System.Collections.Generic.IReadOnlyDictionary<string, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, string>(o, null, null)))
			{
				continue;
			}

			if (propRelocatingNode.TryReadProperty(ref reader, options, PropRelocatingNode, null))
			{
				continue;
			}

			if (propRelocationFailureInfo.TryReadProperty(ref reader, options, PropRelocationFailureInfo, null))
			{
				continue;
			}

			if (propShard.TryReadProperty(ref reader, options, PropShard, null))
			{
				continue;
			}

			if (propState.TryReadProperty(ref reader, options, PropState, null))
			{
				continue;
			}

			if (propUnassignedInfo.TryReadProperty(ref reader, options, PropUnassignedInfo, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.NodeShard(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AllocationId = propAllocationId.Value,
			Index = propIndex.Value,
			Node = propNode.Value,
			Primary = propPrimary.Value,
			RecoverySource = propRecoverySource.Value,
			RelocatingNode = propRelocatingNode.Value,
			RelocationFailureInfo = propRelocationFailureInfo.Value,
			Shard = propShard.Value,
			State = propState.Value,
			UnassignedInfo = propUnassignedInfo.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.NodeShard value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAllocationId, value.AllocationId, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, string>? v) => w.WriteDictionaryValue<string, string>(o, v, null, null));
		writer.WriteProperty(options, PropIndex, value.Index, null, null);
		writer.WriteProperty(options, PropNode, value.Node, null, null);
		writer.WriteProperty(options, PropPrimary, value.Primary, null, null);
		writer.WriteProperty(options, PropRecoverySource, value.RecoverySource, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, string>? v) => w.WriteDictionaryValue<string, string>(o, v, null, null));
		writer.WriteProperty(options, PropRelocatingNode, value.RelocatingNode, null, null);
		writer.WriteProperty(options, PropRelocationFailureInfo, value.RelocationFailureInfo, null, null);
		writer.WriteProperty(options, PropShard, value.Shard, null, null);
		writer.WriteProperty(options, PropState, value.State, null, null);
		writer.WriteProperty(options, PropUnassignedInfo, value.UnassignedInfo, null, null);
		writer.WriteEndObject();
	}
}