// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class NodeRoleConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.NodeRole>
{
	private static readonly System.Text.Json.JsonEncodedText MemberClient = System.Text.Json.JsonEncodedText.Encode("client");
	private static readonly System.Text.Json.JsonEncodedText MemberCoordinatingOnly = System.Text.Json.JsonEncodedText.Encode("coordinating_only");
	private static readonly System.Text.Json.JsonEncodedText MemberData = System.Text.Json.JsonEncodedText.Encode("data");
	private static readonly System.Text.Json.JsonEncodedText MemberDataCold = System.Text.Json.JsonEncodedText.Encode("data_cold");
	private static readonly System.Text.Json.JsonEncodedText MemberDataContent = System.Text.Json.JsonEncodedText.Encode("data_content");
	private static readonly System.Text.Json.JsonEncodedText MemberDataFrozen = System.Text.Json.JsonEncodedText.Encode("data_frozen");
	private static readonly System.Text.Json.JsonEncodedText MemberDataHot = System.Text.Json.JsonEncodedText.Encode("data_hot");
	private static readonly System.Text.Json.JsonEncodedText MemberDataWarm = System.Text.Json.JsonEncodedText.Encode("data_warm");
	private static readonly System.Text.Json.JsonEncodedText MemberIngest = System.Text.Json.JsonEncodedText.Encode("ingest");
	private static readonly System.Text.Json.JsonEncodedText MemberMaster = System.Text.Json.JsonEncodedText.Encode("master");
	private static readonly System.Text.Json.JsonEncodedText MemberMl = System.Text.Json.JsonEncodedText.Encode("ml");
	private static readonly System.Text.Json.JsonEncodedText MemberRemoteClusterClient = System.Text.Json.JsonEncodedText.Encode("remote_cluster_client");
	private static readonly System.Text.Json.JsonEncodedText MemberTransform = System.Text.Json.JsonEncodedText.Encode("transform");
	private static readonly System.Text.Json.JsonEncodedText MemberVotingOnly = System.Text.Json.JsonEncodedText.Encode("voting_only");

	public override Elastic.Clients.Elasticsearch.NodeRole Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberClient))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Client;
		}

		if (reader.ValueTextEquals(MemberCoordinatingOnly))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.CoordinatingOnly;
		}

		if (reader.ValueTextEquals(MemberData))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Data;
		}

		if (reader.ValueTextEquals(MemberDataCold))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataCold;
		}

		if (reader.ValueTextEquals(MemberDataContent))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataContent;
		}

		if (reader.ValueTextEquals(MemberDataFrozen))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataFrozen;
		}

		if (reader.ValueTextEquals(MemberDataHot))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataHot;
		}

		if (reader.ValueTextEquals(MemberDataWarm))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataWarm;
		}

		if (reader.ValueTextEquals(MemberIngest))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Ingest;
		}

		if (reader.ValueTextEquals(MemberMaster))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Master;
		}

		if (reader.ValueTextEquals(MemberMl))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Ml;
		}

		if (reader.ValueTextEquals(MemberRemoteClusterClient))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.RemoteClusterClient;
		}

		if (reader.ValueTextEquals(MemberTransform))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Transform;
		}

		if (reader.ValueTextEquals(MemberVotingOnly))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.VotingOnly;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberClient.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Client;
		}

		if (string.Equals(value, MemberCoordinatingOnly.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.CoordinatingOnly;
		}

		if (string.Equals(value, MemberData.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Data;
		}

		if (string.Equals(value, MemberDataCold.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataCold;
		}

		if (string.Equals(value, MemberDataContent.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataContent;
		}

		if (string.Equals(value, MemberDataFrozen.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataFrozen;
		}

		if (string.Equals(value, MemberDataHot.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataHot;
		}

		if (string.Equals(value, MemberDataWarm.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.DataWarm;
		}

		if (string.Equals(value, MemberIngest.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Ingest;
		}

		if (string.Equals(value, MemberMaster.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Master;
		}

		if (string.Equals(value, MemberMl.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Ml;
		}

		if (string.Equals(value, MemberRemoteClusterClient.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.RemoteClusterClient;
		}

		if (string.Equals(value, MemberTransform.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.Transform;
		}

		if (string.Equals(value, MemberVotingOnly.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.NodeRole.VotingOnly;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.NodeRole)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.NodeRole value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.NodeRole.Client:
				writer.WriteStringValue(MemberClient);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.CoordinatingOnly:
				writer.WriteStringValue(MemberCoordinatingOnly);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.Data:
				writer.WriteStringValue(MemberData);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.DataCold:
				writer.WriteStringValue(MemberDataCold);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.DataContent:
				writer.WriteStringValue(MemberDataContent);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.DataFrozen:
				writer.WriteStringValue(MemberDataFrozen);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.DataHot:
				writer.WriteStringValue(MemberDataHot);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.DataWarm:
				writer.WriteStringValue(MemberDataWarm);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.Ingest:
				writer.WriteStringValue(MemberIngest);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.Master:
				writer.WriteStringValue(MemberMaster);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.Ml:
				writer.WriteStringValue(MemberMl);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.RemoteClusterClient:
				writer.WriteStringValue(MemberRemoteClusterClient);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.Transform:
				writer.WriteStringValue(MemberTransform);
				break;
			case Elastic.Clients.Elasticsearch.NodeRole.VotingOnly:
				writer.WriteStringValue(MemberVotingOnly);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.NodeRole)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.NodeRole ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.NodeRole value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}