// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.TypeMappingConverter))]
public sealed partial class TypeMapping
{
#if NET7_0_OR_GREATER
	public TypeMapping()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TypeMapping()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TypeMapping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Mapping.AllField? AllField { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.DataStreamTimestamp? DataStreamTimestamp { get; set; }
	public bool? DateDetection { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? Dynamic { get; set; }
	public System.Collections.Generic.ICollection<string>? DynamicDateFormats { get; set; }
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>? DynamicTemplates { get; set; }
	public bool? Enabled { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.FieldNamesField? FieldNames { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.IndexField? IndexField { get; set; }
	public System.Collections.Generic.IDictionary<string, object>? Meta { get; set; }
	public bool? NumericDetection { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Properties { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.RoutingField? Routing { get; set; }
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? Runtime { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.SizeField? Size { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.SourceField? Source { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.Subobjects? Subobjects { get; set; }
}

public readonly partial struct TypeMappingDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Mapping.TypeMapping Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TypeMappingDescriptor(Elastic.Clients.Elasticsearch.Mapping.TypeMapping instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TypeMappingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.TypeMapping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Mapping.TypeMapping instance) => new Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.TypeMapping(Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> AllField(Elastic.Clients.Elasticsearch.Mapping.AllField? value)
	{
		Instance.AllField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> AllField(System.Action<Elastic.Clients.Elasticsearch.Mapping.AllFieldDescriptor> action)
	{
		Instance.AllField = Elastic.Clients.Elasticsearch.Mapping.AllFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> DataStreamTimestamp(Elastic.Clients.Elasticsearch.Mapping.DataStreamTimestamp? value)
	{
		Instance.DataStreamTimestamp = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> DataStreamTimestamp(System.Action<Elastic.Clients.Elasticsearch.Mapping.DataStreamTimestampDescriptor> action)
	{
		Instance.DataStreamTimestamp = Elastic.Clients.Elasticsearch.Mapping.DataStreamTimestampDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> DateDetection(bool? value = true)
	{
		Instance.DateDetection = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> DynamicDateFormats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.DynamicDateFormats = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> DynamicDateFormats(params string[] values)
	{
		Instance.DynamicDateFormats = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> DynamicTemplates(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>? value)
	{
		Instance.DynamicTemplates = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> DynamicTemplates()
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> DynamicTemplates(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<TDocument>>? action)
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> AddDynamicTemplate(string key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate value)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> AddDynamicTemplate(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument>> action)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument>.Build(action)));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> FieldNames(Elastic.Clients.Elasticsearch.Mapping.FieldNamesField? value)
	{
		Instance.FieldNames = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> FieldNames(System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldNamesFieldDescriptor> action)
	{
		Instance.FieldNames = Elastic.Clients.Elasticsearch.Mapping.FieldNamesFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> IndexField(Elastic.Clients.Elasticsearch.Mapping.IndexField? value)
	{
		Instance.IndexField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> IndexField(System.Action<Elastic.Clients.Elasticsearch.Mapping.IndexFieldDescriptor> action)
	{
		Instance.IndexField = Elastic.Clients.Elasticsearch.Mapping.IndexFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> NumericDetection(bool? value = true)
	{
		Instance.NumericDetection = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Mapping.RoutingField? value)
	{
		Instance.Routing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Routing(System.Action<Elastic.Clients.Elasticsearch.Mapping.RoutingFieldDescriptor> action)
	{
		Instance.Routing = Elastic.Clients.Elasticsearch.Mapping.RoutingFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Runtime(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.Runtime = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Runtime()
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRuntimeField<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Runtime(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRuntimeField<TDocument>>? action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> AddRuntime(string key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> AddRuntime(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Size(Elastic.Clients.Elasticsearch.Mapping.SizeField? value)
	{
		Instance.Size = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Size(System.Action<Elastic.Clients.Elasticsearch.Mapping.SizeFieldDescriptor> action)
	{
		Instance.Size = Elastic.Clients.Elasticsearch.Mapping.SizeFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.Mapping.SourceField? value)
	{
		Instance.Source = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Source()
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Source(System.Action<Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor>? action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument> Subobjects(Elastic.Clients.Elasticsearch.Mapping.Subobjects? value)
	{
		Instance.Subobjects = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.TypeMapping Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.TypeMapping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Mapping.TypeMapping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TypeMappingDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.TypeMapping Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TypeMappingDescriptor(Elastic.Clients.Elasticsearch.Mapping.TypeMapping instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TypeMappingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.TypeMapping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor(Elastic.Clients.Elasticsearch.Mapping.TypeMapping instance) => new Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.TypeMapping(Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AllField(Elastic.Clients.Elasticsearch.Mapping.AllField? value)
	{
		Instance.AllField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AllField(System.Action<Elastic.Clients.Elasticsearch.Mapping.AllFieldDescriptor> action)
	{
		Instance.AllField = Elastic.Clients.Elasticsearch.Mapping.AllFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DataStreamTimestamp(Elastic.Clients.Elasticsearch.Mapping.DataStreamTimestamp? value)
	{
		Instance.DataStreamTimestamp = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DataStreamTimestamp(System.Action<Elastic.Clients.Elasticsearch.Mapping.DataStreamTimestampDescriptor> action)
	{
		Instance.DataStreamTimestamp = Elastic.Clients.Elasticsearch.Mapping.DataStreamTimestampDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DateDetection(bool? value = true)
	{
		Instance.DateDetection = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DynamicDateFormats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.DynamicDateFormats = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DynamicDateFormats(params string[] values)
	{
		Instance.DynamicDateFormats = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DynamicTemplates(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>? value)
	{
		Instance.DynamicTemplates = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DynamicTemplates()
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DynamicTemplates(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate>? action)
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor DynamicTemplates<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<T>>? action)
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AddDynamicTemplate(string key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate value)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AddDynamicTemplate(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor> action)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor.Build(action)));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AddDynamicTemplate<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<T>> action)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<T>.Build(action)));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor FieldNames(Elastic.Clients.Elasticsearch.Mapping.FieldNamesField? value)
	{
		Instance.FieldNames = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor FieldNames(System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldNamesFieldDescriptor> action)
	{
		Instance.FieldNames = Elastic.Clients.Elasticsearch.Mapping.FieldNamesFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor IndexField(Elastic.Clients.Elasticsearch.Mapping.IndexField? value)
	{
		Instance.IndexField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor IndexField(System.Action<Elastic.Clients.Elasticsearch.Mapping.IndexFieldDescriptor> action)
	{
		Instance.IndexField = Elastic.Clients.Elasticsearch.Mapping.IndexFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor NumericDetection(bool? value = true)
	{
		Instance.NumericDetection = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Properties<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Routing(Elastic.Clients.Elasticsearch.Mapping.RoutingField? value)
	{
		Instance.Routing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Routing(System.Action<Elastic.Clients.Elasticsearch.Mapping.RoutingFieldDescriptor> action)
	{
		Instance.Routing = Elastic.Clients.Elasticsearch.Mapping.RoutingFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Runtime(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.Runtime = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Runtime()
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRuntimeField.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Runtime(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRuntimeField>? action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRuntimeField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Runtime<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRuntimeField<T>>? action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AddRuntime(string key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AddRuntime(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor AddRuntime<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Size(Elastic.Clients.Elasticsearch.Mapping.SizeField? value)
	{
		Instance.Size = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Size(System.Action<Elastic.Clients.Elasticsearch.Mapping.SizeFieldDescriptor> action)
	{
		Instance.Size = Elastic.Clients.Elasticsearch.Mapping.SizeFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Source(Elastic.Clients.Elasticsearch.Mapping.SourceField? value)
	{
		Instance.Source = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Source()
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Source(System.Action<Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor>? action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor Subobjects(Elastic.Clients.Elasticsearch.Mapping.Subobjects? value)
	{
		Instance.Subobjects = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.TypeMapping Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.TypeMapping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor(new Elastic.Clients.Elasticsearch.Mapping.TypeMapping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}