// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class TimeSeriesMetricTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCounter = System.Text.Json.JsonEncodedText.Encode("counter");
	private static readonly System.Text.Json.JsonEncodedText MemberGauge = System.Text.Json.JsonEncodedText.Encode("gauge");
	private static readonly System.Text.Json.JsonEncodedText MemberHistogram = System.Text.Json.JsonEncodedText.Encode("histogram");
	private static readonly System.Text.Json.JsonEncodedText MemberPosition = System.Text.Json.JsonEncodedText.Encode("position");
	private static readonly System.Text.Json.JsonEncodedText MemberSummary = System.Text.Json.JsonEncodedText.Encode("summary");

	public override Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCounter))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Counter;
		}

		if (reader.ValueTextEquals(MemberGauge))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Gauge;
		}

		if (reader.ValueTextEquals(MemberHistogram))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Histogram;
		}

		if (reader.ValueTextEquals(MemberPosition))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Position;
		}

		if (reader.ValueTextEquals(MemberSummary))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Summary;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCounter.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Counter;
		}

		if (string.Equals(value, MemberGauge.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Gauge;
		}

		if (string.Equals(value, MemberHistogram.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Histogram;
		}

		if (string.Equals(value, MemberPosition.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Position;
		}

		if (string.Equals(value, MemberSummary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Summary;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Counter:
				writer.WriteStringValue(MemberCounter);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Gauge:
				writer.WriteStringValue(MemberGauge);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Histogram:
				writer.WriteStringValue(MemberHistogram);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Position:
				writer.WriteStringValue(MemberPosition);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType.Summary:
				writer.WriteStringValue(MemberSummary);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}