// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class TermVectorOptionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.TermVectorOption>
{
	private static readonly System.Text.Json.JsonEncodedText MemberNo = System.Text.Json.JsonEncodedText.Encode("no");
	private static readonly System.Text.Json.JsonEncodedText MemberWithOffsets = System.Text.Json.JsonEncodedText.Encode("with_offsets");
	private static readonly System.Text.Json.JsonEncodedText MemberWithPositions = System.Text.Json.JsonEncodedText.Encode("with_positions");
	private static readonly System.Text.Json.JsonEncodedText MemberWithPositionsOffsets = System.Text.Json.JsonEncodedText.Encode("with_positions_offsets");
	private static readonly System.Text.Json.JsonEncodedText MemberWithPositionsOffsetsPayloads = System.Text.Json.JsonEncodedText.Encode("with_positions_offsets_payloads");
	private static readonly System.Text.Json.JsonEncodedText MemberWithPositionsPayloads = System.Text.Json.JsonEncodedText.Encode("with_positions_payloads");
	private static readonly System.Text.Json.JsonEncodedText MemberYes = System.Text.Json.JsonEncodedText.Encode("yes");

	public override Elastic.Clients.Elasticsearch.Mapping.TermVectorOption Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberNo))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.No;
		}

		if (reader.ValueTextEquals(MemberWithOffsets))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithOffsets;
		}

		if (reader.ValueTextEquals(MemberWithPositions))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositions;
		}

		if (reader.ValueTextEquals(MemberWithPositionsOffsets))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsOffsets;
		}

		if (reader.ValueTextEquals(MemberWithPositionsOffsetsPayloads))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsOffsetsPayloads;
		}

		if (reader.ValueTextEquals(MemberWithPositionsPayloads))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsPayloads;
		}

		if (reader.ValueTextEquals(MemberYes))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.Yes;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberNo.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.No;
		}

		if (string.Equals(value, MemberWithOffsets.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithOffsets;
		}

		if (string.Equals(value, MemberWithPositions.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositions;
		}

		if (string.Equals(value, MemberWithPositionsOffsets.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsOffsets;
		}

		if (string.Equals(value, MemberWithPositionsOffsetsPayloads.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsOffsetsPayloads;
		}

		if (string.Equals(value, MemberWithPositionsPayloads.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsPayloads;
		}

		if (string.Equals(value, MemberYes.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.Yes;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.TermVectorOption)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.TermVectorOption value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.No:
				writer.WriteStringValue(MemberNo);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithOffsets:
				writer.WriteStringValue(MemberWithOffsets);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositions:
				writer.WriteStringValue(MemberWithPositions);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsOffsets:
				writer.WriteStringValue(MemberWithPositionsOffsets);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsOffsetsPayloads:
				writer.WriteStringValue(MemberWithPositionsOffsetsPayloads);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.WithPositionsPayloads:
				writer.WriteStringValue(MemberWithPositionsPayloads);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.TermVectorOption.Yes:
				writer.WriteStringValue(MemberYes);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.TermVectorOption)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.TermVectorOption ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.TermVectorOption value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}