// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.SyntheticSourceKeepEnumConverter))]
public enum SyntheticSourceKeepEnum
{
	/// <summary>
	/// <para>
	/// The source for both singleton instances and arrays of the corresponding field or object gets recorded.
	/// When applied to objects, the source of all sub-objects and sub-fields gets captured.
	/// Furthermore, the original source of arrays gets captured and appears in synthetic source with no modifications.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "all")]
	All,
	/// <summary>
	/// <para>
	/// Arrays of the corresponding field or object preserve the original element ordering and duplicate elements.
	/// The synthetic source fragment for such arrays is not guaranteed to match the original source exactly,
	/// e.g. array [1, 2, [5], [[4, [3]]], 5] may appear as-is or in an equivalent format like [1, 2, 5, 4, 3, 5].
	/// The exact format may change in the future, in an effort to reduce the storage overhead of this option.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "arrays")]
	Arrays,
	/// <summary>
	/// <para>
	/// Synthetic source diverges from the original source (default)
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "none")]
	None
}