// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class SyntheticSourceKeepEnumConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAll = System.Text.Json.JsonEncodedText.Encode("all");
	private static readonly System.Text.Json.JsonEncodedText MemberArrays = System.Text.Json.JsonEncodedText.Encode("arrays");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("none");

	public override Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAll))
		{
			return Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.All;
		}

		if (reader.ValueTextEquals(MemberArrays))
		{
			return Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.Arrays;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.None;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAll.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.All;
		}

		if (string.Equals(value, MemberArrays.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.Arrays;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.None;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.All:
				writer.WriteStringValue(MemberAll);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.Arrays:
				writer.WriteStringValue(MemberArrays);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum.None:
				writer.WriteStringValue(MemberNone);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}