// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class SubobjectsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.Subobjects>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAuto = System.Text.Json.JsonEncodedText.Encode("auto");
	private static readonly System.Text.Json.JsonEncodedText MemberFalse = System.Text.Json.JsonEncodedText.Encode("false");
	private static readonly System.Text.Json.JsonEncodedText MemberTrue = System.Text.Json.JsonEncodedText.Encode("true");

	public override Elastic.Clients.Elasticsearch.Mapping.Subobjects Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAuto))
		{
			return Elastic.Clients.Elasticsearch.Mapping.Subobjects.Auto;
		}

		if (reader.ValueTextEquals(MemberFalse))
		{
			return Elastic.Clients.Elasticsearch.Mapping.Subobjects.False;
		}

		if (reader.ValueTextEquals(MemberTrue))
		{
			return Elastic.Clients.Elasticsearch.Mapping.Subobjects.True;
		}

		if (reader.TokenType is not System.Text.Json.JsonTokenType.String)
		{
			throw new System.Text.Json.JsonException($"Unknown member of type '{reader.TokenType}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.Subobjects)}'.");
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAuto.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.Subobjects.Auto;
		}

		if (string.Equals(value, MemberFalse.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.Subobjects.False;
		}

		if (string.Equals(value, MemberTrue.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.Subobjects.True;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.Subobjects)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.Subobjects value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.Subobjects.Auto:
				writer.WriteStringValue(MemberAuto);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.Subobjects.False:
				writer.WriteRawValue(MemberFalse.EncodedUtf8Bytes);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.Subobjects.True:
				writer.WriteRawValue(MemberTrue.EncodedUtf8Bytes);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.Subobjects)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.Subobjects ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.Subobjects value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}