// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.SparseVectorIndexOptionsConverter))]
public sealed partial class SparseVectorIndexOptions
{
#if NET7_0_OR_GREATER
	public SparseVectorIndexOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SparseVectorIndexOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SparseVectorIndexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Whether to perform pruning, omitting the non-significant tokens from the query to improve query performance.
	/// If prune is true but the pruning_config is not specified, pruning will occur but default values will be used.
	/// Default: false
	/// </para>
	/// </summary>
	public bool? Prune { get; set; }

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TokenPruningConfig? PruningConfig { get; set; }
}

public readonly partial struct SparseVectorIndexOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseVectorIndexOptionsDescriptor(Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseVectorIndexOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor(Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptions instance) => new Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptions(Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Whether to perform pruning, omitting the non-significant tokens from the query to improve query performance.
	/// If prune is true but the pruning_config is not specified, pruning will occur but default values will be used.
	/// Default: false
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor Prune(bool? value = true)
	{
		Instance.Prune = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor PruningConfig(Elastic.Clients.Elasticsearch.TokenPruningConfig? value)
	{
		Instance.PruningConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor PruningConfig()
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor PruningConfig(System.Action<Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor>? action)
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptions Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptionsDescriptor(new Elastic.Clients.Elasticsearch.Mapping.SparseVectorIndexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}