// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.SemanticTextPropertyConverter))]
public sealed partial class SemanticTextProperty : Elastic.Clients.Elasticsearch.Mapping.IProperty
{
#if NET7_0_OR_GREATER
	public SemanticTextProperty()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SemanticTextProperty()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SemanticTextProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Settings for chunking text into smaller passages. If specified, these will override the
	/// chunking settings sent in the inference endpoint associated with inference_id. If chunking settings are updated,
	/// they will not be applied to existing documents until they are reindexed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.ChunkingSettings? ChunkingSettings { get; set; }

	/// <summary>
	/// <para>
	/// Multi-fields allow the same string value to be indexed in multiple ways for different purposes, such as one
	/// field for search and a multi-field for sorting and aggregations, or the same string value analyzed by different analyzers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Inference endpoint that will be used to generate embeddings for the field.
	/// This parameter cannot be updated. Use the Create inference API to create the endpoint.
	/// If <c>search_inference_id</c> is specified, the inference endpoint will only be used at index time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? InferenceId { get; set; }
	public System.Collections.Generic.IDictionary<string, string>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// Inference endpoint that will be used to generate embeddings at query time.
	/// You can update this parameter by using the Update mapping API. Use the Create inference API to create the endpoint.
	/// If not specified, the inference endpoint defined by inference_id will be used at both index and query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? SearchInferenceId { get; set; }

	public string Type => "semantic_text";
}

public readonly partial struct SemanticTextPropertyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SemanticTextPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SemanticTextPropertyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty instance) => new Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty(Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Settings for chunking text into smaller passages. If specified, these will override the
	/// chunking settings sent in the inference endpoint associated with inference_id. If chunking settings are updated,
	/// they will not be applied to existing documents until they are reindexed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> ChunkingSettings(Elastic.Clients.Elasticsearch.Mapping.ChunkingSettings? value)
	{
		Instance.ChunkingSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for chunking text into smaller passages. If specified, these will override the
	/// chunking settings sent in the inference endpoint associated with inference_id. If chunking settings are updated,
	/// they will not be applied to existing documents until they are reindexed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> ChunkingSettings(System.Action<Elastic.Clients.Elasticsearch.Mapping.ChunkingSettingsDescriptor> action)
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Mapping.ChunkingSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Multi-fields allow the same string value to be indexed in multiple ways for different purposes, such as one
	/// field for search and a multi-field for sorting and aggregations, or the same string value analyzed by different analyzers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Multi-fields allow the same string value to be indexed in multiple ways for different purposes, such as one
	/// field for search and a multi-field for sorting and aggregations, or the same string value analyzed by different analyzers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> Fields(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Inference endpoint that will be used to generate embeddings for the field.
	/// This parameter cannot be updated. Use the Create inference API to create the endpoint.
	/// If <c>search_inference_id</c> is specified, the inference endpoint will only be used at index time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> InferenceId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.InferenceId = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Meta = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> AddMeta(string key, string value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Inference endpoint that will be used to generate embeddings at query time.
	/// You can update this parameter by using the Update mapping API. Use the Create inference API to create the endpoint.
	/// If not specified, the inference endpoint defined by inference_id will be used at both index and query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument> SearchInferenceId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.SearchInferenceId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SemanticTextPropertyDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SemanticTextPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SemanticTextPropertyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty instance) => new Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty(Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Settings for chunking text into smaller passages. If specified, these will override the
	/// chunking settings sent in the inference endpoint associated with inference_id. If chunking settings are updated,
	/// they will not be applied to existing documents until they are reindexed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor ChunkingSettings(Elastic.Clients.Elasticsearch.Mapping.ChunkingSettings? value)
	{
		Instance.ChunkingSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for chunking text into smaller passages. If specified, these will override the
	/// chunking settings sent in the inference endpoint associated with inference_id. If chunking settings are updated,
	/// they will not be applied to existing documents until they are reindexed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor ChunkingSettings(System.Action<Elastic.Clients.Elasticsearch.Mapping.ChunkingSettingsDescriptor> action)
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Mapping.ChunkingSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Multi-fields allow the same string value to be indexed in multiple ways for different purposes, such as one
	/// field for search and a multi-field for sorting and aggregations, or the same string value analyzed by different analyzers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor Fields(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Multi-fields allow the same string value to be indexed in multiple ways for different purposes, such as one
	/// field for search and a multi-field for sorting and aggregations, or the same string value analyzed by different analyzers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor Fields(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Multi-fields allow the same string value to be indexed in multiple ways for different purposes, such as one
	/// field for search and a multi-field for sorting and aggregations, or the same string value analyzed by different analyzers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor Fields<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Inference endpoint that will be used to generate embeddings for the field.
	/// This parameter cannot be updated. Use the Create inference API to create the endpoint.
	/// If <c>search_inference_id</c> is specified, the inference endpoint will only be used at index time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.InferenceId = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor Meta(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Meta = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor AddMeta(string key, string value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Inference endpoint that will be used to generate embeddings at query time.
	/// You can update this parameter by using the Update mapping API. Use the Create inference API to create the endpoint.
	/// If not specified, the inference endpoint defined by inference_id will be used at both index and query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor SearchInferenceId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.SearchInferenceId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor(new Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}