// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class RuntimeFieldTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBoolean = System.Text.Json.JsonEncodedText.Encode("boolean");
	private static readonly System.Text.Json.JsonEncodedText MemberComposite = System.Text.Json.JsonEncodedText.Encode("composite");
	private static readonly System.Text.Json.JsonEncodedText MemberDate = System.Text.Json.JsonEncodedText.Encode("date");
	private static readonly System.Text.Json.JsonEncodedText MemberDouble = System.Text.Json.JsonEncodedText.Encode("double");
	private static readonly System.Text.Json.JsonEncodedText MemberGeoPoint = System.Text.Json.JsonEncodedText.Encode("geo_point");
	private static readonly System.Text.Json.JsonEncodedText MemberGeoShape = System.Text.Json.JsonEncodedText.Encode("geo_shape");
	private static readonly System.Text.Json.JsonEncodedText MemberIp = System.Text.Json.JsonEncodedText.Encode("ip");
	private static readonly System.Text.Json.JsonEncodedText MemberKeyword = System.Text.Json.JsonEncodedText.Encode("keyword");
	private static readonly System.Text.Json.JsonEncodedText MemberLong = System.Text.Json.JsonEncodedText.Encode("long");
	private static readonly System.Text.Json.JsonEncodedText MemberLookup = System.Text.Json.JsonEncodedText.Encode("lookup");

	public override Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBoolean))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Boolean;
		}

		if (reader.ValueTextEquals(MemberComposite))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Composite;
		}

		if (reader.ValueTextEquals(MemberDate))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Date;
		}

		if (reader.ValueTextEquals(MemberDouble))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Double;
		}

		if (reader.ValueTextEquals(MemberGeoPoint))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.GeoPoint;
		}

		if (reader.ValueTextEquals(MemberGeoShape))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.GeoShape;
		}

		if (reader.ValueTextEquals(MemberIp))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Ip;
		}

		if (reader.ValueTextEquals(MemberKeyword))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Keyword;
		}

		if (reader.ValueTextEquals(MemberLong))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Long;
		}

		if (reader.ValueTextEquals(MemberLookup))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Lookup;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBoolean.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Boolean;
		}

		if (string.Equals(value, MemberComposite.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Composite;
		}

		if (string.Equals(value, MemberDate.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Date;
		}

		if (string.Equals(value, MemberDouble.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Double;
		}

		if (string.Equals(value, MemberGeoPoint.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.GeoPoint;
		}

		if (string.Equals(value, MemberGeoShape.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.GeoShape;
		}

		if (string.Equals(value, MemberIp.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Ip;
		}

		if (string.Equals(value, MemberKeyword.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Keyword;
		}

		if (string.Equals(value, MemberLong.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Long;
		}

		if (string.Equals(value, MemberLookup.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Lookup;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Boolean:
				writer.WriteStringValue(MemberBoolean);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Composite:
				writer.WriteStringValue(MemberComposite);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Date:
				writer.WriteStringValue(MemberDate);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Double:
				writer.WriteStringValue(MemberDouble);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.GeoPoint:
				writer.WriteStringValue(MemberGeoPoint);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.GeoShape:
				writer.WriteStringValue(MemberGeoShape);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Ip:
				writer.WriteStringValue(MemberIp);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Keyword:
				writer.WriteStringValue(MemberKeyword);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Long:
				writer.WriteStringValue(MemberLong);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType.Lookup:
				writer.WriteStringValue(MemberLookup);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}