// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.RuntimeFieldConverter))]
public sealed partial class RuntimeField
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuntimeField(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType type)
	{
		Type = type;
	}
#if NET7_0_OR_GREATER
	public RuntimeField()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RuntimeField()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RuntimeField(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFields>? FetchFields { get; set; }

	/// <summary>
	/// <para>
	/// For type <c>composite</c>
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// A custom format for <c>date</c> type runtime fields.
	/// </para>
	/// </summary>
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? InputField { get; set; }

	/// <summary>
	/// <para>
	/// Painless script executed at query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TargetField { get; set; }

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? TargetIndex { get; set; }

	/// <summary>
	/// <para>
	/// Field type, which can be: <c>boolean</c>, <c>composite</c>, <c>date</c>, <c>double</c>, <c>geo_point</c>, <c>ip</c>,<c>keyword</c>, <c>long</c>, or <c>lookup</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType Type { get; set; }
}

public readonly partial struct RuntimeFieldDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Mapping.RuntimeField Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuntimeFieldDescriptor(Elastic.Clients.Elasticsearch.Mapping.RuntimeField instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuntimeFieldDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.RuntimeField(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Mapping.RuntimeField instance) => new Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.RuntimeField(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> FetchFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFields>? value)
	{
		Instance.FetchFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> FetchFields(params Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFields[] values)
	{
		Instance.FetchFields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> FetchFields(params System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFieldsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFields>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFieldsDescriptor<TDocument>.Build(action));
		}

		Instance.FetchFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>composite</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> Fields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>composite</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> Fields()
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCompositeSubField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>composite</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> Fields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCompositeSubField>? action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCompositeSubField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> AddField(string key, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField value)
	{
		Instance.Fields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField>();
		Instance.Fields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> AddField(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CompositeSubFieldDescriptor> action)
	{
		Instance.Fields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField>();
		Instance.Fields.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompositeSubFieldDescriptor.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// A custom format for <c>date</c> type runtime fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> InputField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.InputField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> InputField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.InputField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Painless script executed at query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Painless script executed at query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Painless script executed at query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> TargetField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> TargetIndex(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.TargetIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field type, which can be: <c>boolean</c>, <c>composite</c>, <c>date</c>, <c>double</c>, <c>geo_point</c>, <c>ip</c>,<c>keyword</c>, <c>long</c>, or <c>lookup</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument> Type(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.RuntimeField Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Mapping.RuntimeField(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RuntimeFieldDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.RuntimeField Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuntimeFieldDescriptor(Elastic.Clients.Elasticsearch.Mapping.RuntimeField instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuntimeFieldDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.RuntimeField(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor(Elastic.Clients.Elasticsearch.Mapping.RuntimeField instance) => new Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.RuntimeField(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor FetchFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFields>? value)
	{
		Instance.FetchFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor FetchFields(params Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFields[] values)
	{
		Instance.FetchFields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor FetchFields(params System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFieldsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFields>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFieldsDescriptor.Build(action));
		}

		Instance.FetchFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor FetchFields<T>(params System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFieldsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFields>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldFetchFieldsDescriptor<T>.Build(action));
		}

		Instance.FetchFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>composite</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor Fields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>composite</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor Fields()
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCompositeSubField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>composite</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor Fields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCompositeSubField>? action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCompositeSubField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor AddField(string key, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField value)
	{
		Instance.Fields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField>();
		Instance.Fields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor AddField(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CompositeSubFieldDescriptor> action)
	{
		Instance.Fields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Mapping.CompositeSubField>();
		Instance.Fields.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompositeSubFieldDescriptor.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// A custom format for <c>date</c> type runtime fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor InputField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.InputField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor InputField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.InputField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Painless script executed at query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Painless script executed at query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Painless script executed at query time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor TargetField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For type <c>lookup</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor TargetIndex(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.TargetIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field type, which can be: <c>boolean</c>, <c>composite</c>, <c>date</c>, <c>double</c>, <c>geo_point</c>, <c>ip</c>,<c>keyword</c>, <c>long</c>, or <c>lookup</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor Type(Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldType value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.RuntimeField Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor(new Elastic.Clients.Elasticsearch.Mapping.RuntimeField(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}