// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class RankVectorElementTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBit = System.Text.Json.JsonEncodedText.Encode("bit");
	private static readonly System.Text.Json.JsonEncodedText MemberByte = System.Text.Json.JsonEncodedText.Encode("byte");
	private static readonly System.Text.Json.JsonEncodedText MemberFloat = System.Text.Json.JsonEncodedText.Encode("float");

	public override Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBit))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Bit;
		}

		if (reader.ValueTextEquals(MemberByte))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Byte;
		}

		if (reader.ValueTextEquals(MemberFloat))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Float;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBit.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Bit;
		}

		if (string.Equals(value, MemberByte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Byte;
		}

		if (string.Equals(value, MemberFloat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Float;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Bit:
				writer.WriteStringValue(MemberBit);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Byte:
				writer.WriteStringValue(MemberByte);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType.Float:
				writer.WriteStringValue(MemberFloat);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.RankVectorElementType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}