// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.IPropertyConverter))]
public partial interface IProperty
{
	public string Type { get; }
}

public readonly partial struct PropertyFactory<TDocument>
{
	public Elastic.Clients.Elasticsearch.Mapping.IProperty Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Dynamic()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Dynamic(System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty AggregateMetricDouble(Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty AggregateMetricDouble(System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<TDocument>> action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FieldAlias(Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FieldAlias()
	{
		return Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FieldAlias(System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Binary(Elastic.Clients.Elasticsearch.Mapping.BinaryProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Binary()
	{
		return Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Binary(System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Boolean(Elastic.Clients.Elasticsearch.Mapping.BooleanProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Boolean()
	{
		return Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Boolean(System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ByteNumber(Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ByteNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ByteNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Completion(Elastic.Clients.Elasticsearch.Mapping.CompletionProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Completion()
	{
		return Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Completion(System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ConstantKeyword(Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ConstantKeyword()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ConstantKeyword(System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty CountedKeyword(Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty CountedKeyword()
	{
		return Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty CountedKeyword(System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Date(Elastic.Clients.Elasticsearch.Mapping.DateProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Date()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Date(System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateNanos(Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateNanos()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateNanos(System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateRange(Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DenseVector(Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DenseVector()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DenseVector(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleNumber(Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleRange(Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Flattened(Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Flattened()
	{
		return Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Flattened(System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatNumber(Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatRange(Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoPoint(Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoPoint()
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoPoint(System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoShape(Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoShape()
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoShape(System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty HalfFloatNumber(Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty HalfFloatNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty HalfFloatNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Histogram(Elastic.Clients.Elasticsearch.Mapping.HistogramProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Histogram()
	{
		return Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Histogram(System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IcuCollation(Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IcuCollation()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IcuCollation(System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerNumber(Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerRange(Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Ip(Elastic.Clients.Elasticsearch.Mapping.IpProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Ip()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Ip(System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IpRange(Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IpRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IpRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Join(Elastic.Clients.Elasticsearch.Mapping.JoinProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Join()
	{
		return Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Join(System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Keyword(Elastic.Clients.Elasticsearch.Mapping.KeywordProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Keyword()
	{
		return Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Keyword(System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongNumber(Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongRange(Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty MatchOnlyText(Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty MatchOnlyText()
	{
		return Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty MatchOnlyText(System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Murmur3Hash(Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Murmur3Hash()
	{
		return Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Murmur3Hash(System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Nested(Elastic.Clients.Elasticsearch.Mapping.NestedProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Nested()
	{
		return Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Nested(System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Object(Elastic.Clients.Elasticsearch.Mapping.ObjectProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Object()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Object(System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty PassthroughObject(Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty PassthroughObject()
	{
		return Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty PassthroughObject(System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Percolator(Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Percolator()
	{
		return Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Percolator(System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Point(Elastic.Clients.Elasticsearch.Mapping.PointProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Point()
	{
		return Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Point(System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeature(Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeature()
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeature(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeatures(Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeatures()
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeatures(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankVector(Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankVector()
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankVector(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ScaledFloatNumber(Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ScaledFloatNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ScaledFloatNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SearchAsYouType(Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SearchAsYouType()
	{
		return Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SearchAsYouType(System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SemanticText(Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SemanticText()
	{
		return Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SemanticText(System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Shape(Elastic.Clients.Elasticsearch.Mapping.ShapeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Shape()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Shape(System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ShortNumber(Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ShortNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ShortNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SparseVector(Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SparseVector()
	{
		return Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SparseVector(System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Text(Elastic.Clients.Elasticsearch.Mapping.TextProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Text()
	{
		return Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Text(System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty TokenCount(Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty TokenCount()
	{
		return Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty TokenCount(System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty UnsignedLongNumber(Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty UnsignedLongNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty UnsignedLongNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Version(Elastic.Clients.Elasticsearch.Mapping.VersionProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Version()
	{
		return Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Version(System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Wildcard(Elastic.Clients.Elasticsearch.Mapping.WildcardProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Wildcard()
	{
		return Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Wildcard(System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>.Build(action);
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.IProperty Build(System.Func<Elastic.Clients.Elasticsearch.Mapping.PropertyFactory<TDocument>, Elastic.Clients.Elasticsearch.Mapping.IProperty> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Mapping.PropertyFactory<TDocument>();
		return action.Invoke(builder);
	}
}

public readonly partial struct PropertyFactory
{
	public Elastic.Clients.Elasticsearch.Mapping.IProperty Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Dynamic()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Dynamic(System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Dynamic<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty AggregateMetricDouble(Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty AggregateMetricDouble(System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty AggregateMetricDouble<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<T>> action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FieldAlias(Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FieldAlias()
	{
		return Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FieldAlias(System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FieldAlias<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Binary(Elastic.Clients.Elasticsearch.Mapping.BinaryProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Binary()
	{
		return Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Binary(System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Binary<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Boolean(Elastic.Clients.Elasticsearch.Mapping.BooleanProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Boolean()
	{
		return Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Boolean(System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Boolean<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ByteNumber(Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ByteNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ByteNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ByteNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Completion(Elastic.Clients.Elasticsearch.Mapping.CompletionProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Completion()
	{
		return Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Completion(System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Completion<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ConstantKeyword(Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ConstantKeyword()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ConstantKeyword(System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ConstantKeyword<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty CountedKeyword(Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty CountedKeyword()
	{
		return Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty CountedKeyword(System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty CountedKeyword<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Date(Elastic.Clients.Elasticsearch.Mapping.DateProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Date()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Date(System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Date<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateNanos(Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateNanos()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateNanos(System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateNanos<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateRange(Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DateRange<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DenseVector(Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DenseVector()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DenseVector(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DenseVector<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleNumber(Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleRange(Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty DoubleRange<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Flattened(Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Flattened()
	{
		return Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Flattened(System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Flattened<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatNumber(Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatRange(Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty FloatRange<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoPoint(Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoPoint()
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoPoint(System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoPoint<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoShape(Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoShape()
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoShape(System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty GeoShape<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty HalfFloatNumber(Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty HalfFloatNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty HalfFloatNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty HalfFloatNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Histogram(Elastic.Clients.Elasticsearch.Mapping.HistogramProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Histogram()
	{
		return Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Histogram(System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Histogram<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IcuCollation(Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IcuCollation()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IcuCollation(System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IcuCollation<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerNumber(Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerRange(Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IntegerRange<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Ip(Elastic.Clients.Elasticsearch.Mapping.IpProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Ip()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Ip(System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Ip<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IpRange(Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IpRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IpRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty IpRange<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Join(Elastic.Clients.Elasticsearch.Mapping.JoinProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Join()
	{
		return Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Join(System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Join<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Keyword(Elastic.Clients.Elasticsearch.Mapping.KeywordProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Keyword()
	{
		return Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Keyword(System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Keyword<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongNumber(Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongRange(Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongRange()
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongRange(System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty LongRange<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty MatchOnlyText(Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty MatchOnlyText()
	{
		return Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty MatchOnlyText(System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty MatchOnlyText<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Murmur3Hash(Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Murmur3Hash()
	{
		return Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Murmur3Hash(System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Murmur3Hash<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Nested(Elastic.Clients.Elasticsearch.Mapping.NestedProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Nested()
	{
		return Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Nested(System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Nested<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Object(Elastic.Clients.Elasticsearch.Mapping.ObjectProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Object()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Object(System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Object<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty PassthroughObject(Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty PassthroughObject()
	{
		return Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty PassthroughObject(System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty PassthroughObject<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Percolator(Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Percolator()
	{
		return Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Percolator(System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Percolator<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Point(Elastic.Clients.Elasticsearch.Mapping.PointProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Point()
	{
		return Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Point(System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Point<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeature(Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeature()
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeature(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeature<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeatures(Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeatures()
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeatures(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankFeatures<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankVector(Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankVector()
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankVector(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty RankVector<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ScaledFloatNumber(Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ScaledFloatNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ScaledFloatNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ScaledFloatNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SearchAsYouType(Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SearchAsYouType()
	{
		return Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SearchAsYouType(System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SearchAsYouType<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SemanticText(Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SemanticText()
	{
		return Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SemanticText(System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SemanticText<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Shape(Elastic.Clients.Elasticsearch.Mapping.ShapeProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Shape()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Shape(System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Shape<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ShortNumber(Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ShortNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ShortNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty ShortNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SparseVector(Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SparseVector()
	{
		return Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SparseVector(System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty SparseVector<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Text(Elastic.Clients.Elasticsearch.Mapping.TextProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Text()
	{
		return Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Text(System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Text<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty TokenCount(Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty TokenCount()
	{
		return Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty TokenCount(System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty TokenCount<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty UnsignedLongNumber(Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty UnsignedLongNumber()
	{
		return Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty UnsignedLongNumber(System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty UnsignedLongNumber<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Version(Elastic.Clients.Elasticsearch.Mapping.VersionProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Version()
	{
		return Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Version(System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Version<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<T>.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Wildcard(Elastic.Clients.Elasticsearch.Mapping.WildcardProperty value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Wildcard()
	{
		return Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Wildcard(System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty Wildcard<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<T>>? action)
	{
		return Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<T>.Build(action);
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.IProperty Build(System.Func<Elastic.Clients.Elasticsearch.Mapping.PropertyFactory, Elastic.Clients.Elasticsearch.Mapping.IProperty> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Mapping.PropertyFactory();
		return action.Invoke(builder);
	}
}