// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class IPropertyConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.IProperty>
{
	private static readonly System.Text.Json.JsonEncodedText PropDiscriminator = System.Text.Json.JsonEncodedText.Encode("type");

	public override Elastic.Clients.Elasticsearch.Mapping.IProperty Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		var readerSnapshot = reader;
		string? discriminator = "object";
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.TryReadProperty(options, PropDiscriminator, ref discriminator, null))
			{
				break;
			}

			reader.SafeSkip();
		}

		reader = readerSnapshot;
		return discriminator switch
		{
			"{dynamic_type}" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.DynamicProperty>(options, null),
			"aggregate_metric_double" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty>(options, null),
			"alias" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty>(options, null),
			"binary" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.BinaryProperty>(options, null),
			"boolean" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.BooleanProperty>(options, null),
			"byte" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty>(options, null),
			"completion" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.CompletionProperty>(options, null),
			"constant_keyword" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty>(options, null),
			"counted_keyword" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty>(options, null),
			"date" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.DateProperty>(options, null),
			"date_nanos" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty>(options, null),
			"date_range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty>(options, null),
			"dense_vector" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty>(options, null),
			"double" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty>(options, null),
			"double_range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty>(options, null),
			"flattened" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty>(options, null),
			"float" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty>(options, null),
			"float_range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty>(options, null),
			"geo_point" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty>(options, null),
			"geo_shape" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty>(options, null),
			"half_float" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty>(options, null),
			"histogram" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.HistogramProperty>(options, null),
			"icu_collation_keyword" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty>(options, null),
			"integer" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty>(options, null),
			"integer_range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty>(options, null),
			"ip" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.IpProperty>(options, null),
			"ip_range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty>(options, null),
			"join" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.JoinProperty>(options, null),
			"keyword" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.KeywordProperty>(options, null),
			"long" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty>(options, null),
			"long_range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty>(options, null),
			"match_only_text" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty>(options, null),
			"murmur3" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty>(options, null),
			"nested" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.NestedProperty>(options, null),
			"object" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.ObjectProperty>(options, null),
			"passthrough" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty>(options, null),
			"percolator" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty>(options, null),
			"point" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.PointProperty>(options, null),
			"rank_feature" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty>(options, null),
			"rank_features" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty>(options, null),
			"rank_vectors" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty>(options, null),
			"scaled_float" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty>(options, null),
			"search_as_you_type" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty>(options, null),
			"semantic_text" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty>(options, null),
			"shape" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.ShapeProperty>(options, null),
			"short" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty>(options, null),
			"sparse_vector" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty>(options, null),
			"text" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.TextProperty>(options, null),
			"token_count" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty>(options, null),
			"unsigned_long" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty>(options, null),
			"version" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.VersionProperty>(options, null),
			"wildcard" => reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.WildcardProperty>(options, null),
			_ => throw new System.Text.Json.JsonException($"Variant '{discriminator}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Mapping.IProperty)}'.")
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.IProperty value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value.Type)
		{
			case "{dynamic_type}":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.DynamicProperty)value, null);
				break;
			case "aggregate_metric_double":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty)value, null);
				break;
			case "alias":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty)value, null);
				break;
			case "binary":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.BinaryProperty)value, null);
				break;
			case "boolean":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.BooleanProperty)value, null);
				break;
			case "byte":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty)value, null);
				break;
			case "completion":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.CompletionProperty)value, null);
				break;
			case "constant_keyword":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty)value, null);
				break;
			case "counted_keyword":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty)value, null);
				break;
			case "date":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.DateProperty)value, null);
				break;
			case "date_nanos":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty)value, null);
				break;
			case "date_range":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty)value, null);
				break;
			case "dense_vector":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty)value, null);
				break;
			case "double":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty)value, null);
				break;
			case "double_range":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty)value, null);
				break;
			case "flattened":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty)value, null);
				break;
			case "float":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty)value, null);
				break;
			case "float_range":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty)value, null);
				break;
			case "geo_point":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty)value, null);
				break;
			case "geo_shape":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty)value, null);
				break;
			case "half_float":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty)value, null);
				break;
			case "histogram":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.HistogramProperty)value, null);
				break;
			case "icu_collation_keyword":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty)value, null);
				break;
			case "integer":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty)value, null);
				break;
			case "integer_range":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty)value, null);
				break;
			case "ip":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.IpProperty)value, null);
				break;
			case "ip_range":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty)value, null);
				break;
			case "join":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.JoinProperty)value, null);
				break;
			case "keyword":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.KeywordProperty)value, null);
				break;
			case "long":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty)value, null);
				break;
			case "long_range":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty)value, null);
				break;
			case "match_only_text":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty)value, null);
				break;
			case "murmur3":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty)value, null);
				break;
			case "nested":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.NestedProperty)value, null);
				break;
			case "object":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.ObjectProperty)value, null);
				break;
			case "passthrough":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty)value, null);
				break;
			case "percolator":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty)value, null);
				break;
			case "point":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.PointProperty)value, null);
				break;
			case "rank_feature":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty)value, null);
				break;
			case "rank_features":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty)value, null);
				break;
			case "rank_vectors":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty)value, null);
				break;
			case "scaled_float":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty)value, null);
				break;
			case "search_as_you_type":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty)value, null);
				break;
			case "semantic_text":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty)value, null);
				break;
			case "shape":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.ShapeProperty)value, null);
				break;
			case "short":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty)value, null);
				break;
			case "sparse_vector":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty)value, null);
				break;
			case "text":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.TextProperty)value, null);
				break;
			case "token_count":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty)value, null);
				break;
			case "unsigned_long":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty)value, null);
				break;
			case "version":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.VersionProperty)value, null);
				break;
			case "wildcard":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Mapping.WildcardProperty)value, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.Type}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Mapping.IProperty)}'.");
		}
	}
}