// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

public partial class Properties : Elastic.Clients.Elasticsearch.IsADictionary<Elastic.Clients.Elasticsearch.PropertyName, Elastic.Clients.Elasticsearch.Mapping.IProperty>
{
	public Properties()
	{
	}

	public Properties(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.PropertyName, Elastic.Clients.Elasticsearch.Mapping.IProperty> backingDictionary) : base(backingDictionary)
	{
	}

	public void Add(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IProperty value) => BackingDictionary.Add(Sanitize(key), value);
	public bool TryGetProperty(Elastic.Clients.Elasticsearch.PropertyName key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out Elastic.Clients.Elasticsearch.Mapping.IProperty value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetProperty<T>(Elastic.Clients.Elasticsearch.PropertyName key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, IProperty
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}
}

public readonly partial struct PropertiesDescriptor<TDocument>
{
	private readonly Elastic.Clients.Elasticsearch.Mapping.Properties _items = new();

	private Elastic.Clients.Elasticsearch.Mapping.Properties Value => _items;

	public PropertiesDescriptor()
	{
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Dynamic(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DynamicProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Dynamic(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DynamicProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Dynamic(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Dynamic(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Dynamic(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Dynamic(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> AggregateMetricDouble(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> AggregateMetricDouble(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> AggregateMetricDouble(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<TDocument>> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> AggregateMetricDouble(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<TDocument>> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FieldAlias(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FieldAlias(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FieldAlias(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FieldAlias(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FieldAlias(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FieldAlias(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Binary(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.BinaryProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Binary(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.BinaryProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Binary(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Binary(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Binary(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Binary(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Boolean(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.BooleanProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Boolean(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.BooleanProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Boolean(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Boolean(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Boolean(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Boolean(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ByteNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ByteNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ByteNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ByteNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ByteNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ByteNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Completion(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.CompletionProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Completion(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.CompletionProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Completion(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Completion(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Completion(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Completion(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ConstantKeyword(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ConstantKeyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ConstantKeyword(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ConstantKeyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ConstantKeyword(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ConstantKeyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> CountedKeyword(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> CountedKeyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> CountedKeyword(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> CountedKeyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> CountedKeyword(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> CountedKeyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Date(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DateProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Date(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DateProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Date(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Date(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Date(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Date(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateNanos(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateNanos(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateNanos(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateNanos(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateNanos(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateNanos(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DateRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DenseVector(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DenseVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DenseVector(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DenseVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DenseVector(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DenseVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> DoubleRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Flattened(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Flattened(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Flattened(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Flattened(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Flattened(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Flattened(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> FloatRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoPoint(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoPoint(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoPoint(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoPoint(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoPoint(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoPoint(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoShape(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoShape(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoShape(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoShape(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoShape(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> GeoShape(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> HalfFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> HalfFloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> HalfFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> HalfFloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> HalfFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> HalfFloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Histogram(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.HistogramProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Histogram(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.HistogramProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Histogram(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Histogram(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Histogram(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Histogram(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IcuCollation(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IcuCollation(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IcuCollation(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IcuCollation(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IcuCollation(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IcuCollation(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IntegerRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Ip(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IpProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Ip(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IpProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Ip(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Ip(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Ip(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Ip(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IpRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IpRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IpRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IpRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IpRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> IpRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Join(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.JoinProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Join(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.JoinProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Join(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Join(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Join(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Join(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Keyword(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.KeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Keyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.KeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Keyword(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Keyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Keyword(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Keyword(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> LongRange(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> MatchOnlyText(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> MatchOnlyText(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> MatchOnlyText(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> MatchOnlyText(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> MatchOnlyText(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> MatchOnlyText(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Murmur3Hash(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Murmur3Hash(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Murmur3Hash(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Murmur3Hash(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Murmur3Hash(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Murmur3Hash(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Nested(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.NestedProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Nested(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.NestedProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Nested(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Nested(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Nested(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Nested(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Object(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ObjectProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Object(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ObjectProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Object(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Object(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Object(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Object(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> PassthroughObject(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> PassthroughObject(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> PassthroughObject(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> PassthroughObject(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> PassthroughObject(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> PassthroughObject(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Percolator(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Percolator(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Percolator(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Percolator(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Percolator(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Percolator(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Point(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.PointProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Point(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.PointProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Point(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Point(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Point(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Point(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeature(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeature(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeature(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeature(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeature(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeature(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeatures(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeatures(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeatures(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeatures(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeatures(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankFeatures(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankVector(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankVector(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankVector(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> RankVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ScaledFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ScaledFloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ScaledFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ScaledFloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ScaledFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ScaledFloatNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SearchAsYouType(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SearchAsYouType(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SearchAsYouType(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SearchAsYouType(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SearchAsYouType(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SearchAsYouType(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SemanticText(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SemanticText(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SemanticText(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SemanticText(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SemanticText(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SemanticText(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Shape(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ShapeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Shape(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ShapeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Shape(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Shape(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Shape(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Shape(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ShortNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ShortNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ShortNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ShortNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ShortNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> ShortNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SparseVector(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SparseVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SparseVector(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SparseVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SparseVector(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> SparseVector(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Text(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.TextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Text(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.TextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Text(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Text(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Text(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Text(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> TokenCount(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> TokenCount(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> TokenCount(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> TokenCount(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> TokenCount(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> TokenCount(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> UnsignedLongNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> UnsignedLongNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> UnsignedLongNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> UnsignedLongNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> UnsignedLongNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> UnsignedLongNumber(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Version(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.VersionProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Version(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.VersionProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Version(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Version(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Version(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Version(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Wildcard(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.WildcardProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Wildcard(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.WildcardProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Wildcard(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Wildcard(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Wildcard(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument> Wildcard(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<TDocument>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.Properties Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.Properties();
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>();
		action.Invoke(builder);
		return builder.Value;
	}
}

public readonly partial struct PropertiesDescriptor
{
	private readonly Elastic.Clients.Elasticsearch.Mapping.Properties _items = new();

	private Elastic.Clients.Elasticsearch.Mapping.Properties Value => _items;

	public PropertiesDescriptor()
	{
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Dynamic(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DynamicProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Dynamic<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DynamicProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Dynamic(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Dynamic<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Dynamic(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Dynamic<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Dynamic<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Dynamic<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor AggregateMetricDouble(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor AggregateMetricDouble<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor AggregateMetricDouble(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor AggregateMetricDouble<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor AggregateMetricDouble<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<T>> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor AggregateMetricDouble<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<T>> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoublePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FieldAlias(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FieldAlias<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FieldAlias(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FieldAlias<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FieldAlias(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FieldAlias<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FieldAlias<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FieldAlias<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FieldAliasPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Binary(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.BinaryProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Binary<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.BinaryProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Binary(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Binary<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Binary(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Binary<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Binary<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Binary<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BinaryPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Boolean(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.BooleanProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Boolean<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.BooleanProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Boolean(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Boolean<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Boolean(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Boolean<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Boolean<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Boolean<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.BooleanPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ByteNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ByteNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ByteNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ByteNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ByteNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ByteNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ByteNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ByteNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ByteNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Completion(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.CompletionProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Completion<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.CompletionProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Completion(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Completion<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Completion(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Completion<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Completion<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Completion<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ConstantKeyword(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ConstantKeyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ConstantKeyword(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ConstantKeyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ConstantKeyword(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ConstantKeyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ConstantKeyword<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ConstantKeyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor CountedKeyword(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor CountedKeyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor CountedKeyword(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor CountedKeyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor CountedKeyword(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor CountedKeyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor CountedKeyword<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor CountedKeyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.CountedKeywordPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Date(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DateProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Date<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DateProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Date(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Date<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Date(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Date<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Date<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Date<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DatePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateNanos(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateNanos<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateNanos(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateNanos<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateNanos(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateNanos<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateNanos<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateNanos<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateNanosPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateRange<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DateRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DateRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DenseVector(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DenseVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DenseVector(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DenseVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DenseVector(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DenseVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DenseVector<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DenseVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleRange<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor DoubleRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.DoubleRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Flattened(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Flattened<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Flattened(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Flattened<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Flattened(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Flattened<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Flattened<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Flattened<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FlattenedPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatRange<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor FloatRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.FloatRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoPoint(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoPoint<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoPoint(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoPoint<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoPoint(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoPoint<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoPoint<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoPoint<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoPointPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoShape(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoShape<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoShape(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoShape<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoShape(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoShape<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoShape<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor GeoShape<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.GeoShapePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor HalfFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor HalfFloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor HalfFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor HalfFloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor HalfFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor HalfFloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor HalfFloatNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor HalfFloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Histogram(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.HistogramProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Histogram<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.HistogramProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Histogram(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Histogram<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Histogram(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Histogram<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Histogram<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Histogram<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.HistogramPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IcuCollation(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IcuCollation<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IcuCollation(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IcuCollation<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IcuCollation(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IcuCollation<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IcuCollation<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IcuCollation<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IcuCollationPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerRange<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IntegerRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IntegerRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Ip(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IpProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Ip<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IpProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Ip(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Ip<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Ip(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Ip<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Ip<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Ip<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IpRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IpRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IpRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IpRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IpRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IpRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IpRange<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor IpRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.IpRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Join(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.JoinProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Join<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.JoinProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Join(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Join<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Join(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Join<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Join<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Join<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.JoinPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Keyword(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.KeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Keyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.KeywordProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Keyword(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Keyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Keyword(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Keyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Keyword<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Keyword<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.KeywordPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongRange(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongRange(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongRange(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongRange<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor LongRange<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.LongRangePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor MatchOnlyText(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor MatchOnlyText<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor MatchOnlyText(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor MatchOnlyText<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor MatchOnlyText(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor MatchOnlyText<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor MatchOnlyText<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor MatchOnlyText<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Murmur3Hash(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Murmur3Hash<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Murmur3Hash(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Murmur3Hash<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Murmur3Hash(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Murmur3Hash<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Murmur3Hash<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Murmur3Hash<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.Murmur3HashPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Nested(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.NestedProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Nested<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.NestedProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Nested(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Nested<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Nested(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Nested<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Nested<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Nested<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.NestedPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Object(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ObjectProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Object<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ObjectProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Object(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Object<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Object(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Object<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Object<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Object<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ObjectPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor PassthroughObject(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor PassthroughObject<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor PassthroughObject(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor PassthroughObject<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor PassthroughObject(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor PassthroughObject<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor PassthroughObject<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor PassthroughObject<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Percolator(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Percolator<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Percolator(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Percolator<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Percolator(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Percolator<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Percolator<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Percolator<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PercolatorPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Point(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.PointProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Point<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.PointProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Point(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Point<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Point(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Point<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Point<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Point<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.PointPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeature(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeature<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeature(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeature<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeature(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeature<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeature<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeature<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeatures(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeatures<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeatures(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeatures<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeatures(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeatures<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeatures<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankFeatures<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankFeaturesPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankVector(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankVector(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankVector(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankVector<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor RankVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.RankVectorPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ScaledFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ScaledFloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ScaledFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ScaledFloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ScaledFloatNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ScaledFloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ScaledFloatNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ScaledFloatNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SearchAsYouType(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SearchAsYouType<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SearchAsYouType(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SearchAsYouType<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SearchAsYouType(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SearchAsYouType<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SearchAsYouType<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SearchAsYouType<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SemanticText(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SemanticText<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SemanticText(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SemanticText<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SemanticText(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SemanticText<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SemanticText<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SemanticText<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SemanticTextPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Shape(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ShapeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Shape<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ShapeProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Shape(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Shape<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Shape(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Shape<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Shape<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Shape<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShapePropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ShortNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ShortNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ShortNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ShortNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ShortNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ShortNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ShortNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor ShortNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.ShortNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SparseVector(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SparseVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SparseVector(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SparseVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SparseVector(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SparseVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SparseVector<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor SparseVector<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.SparseVectorPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Text(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.TextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Text<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.TextProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Text(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Text<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Text(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Text<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Text<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Text<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TextPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor TokenCount(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor TokenCount<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor TokenCount(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor TokenCount<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor TokenCount(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor TokenCount<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor TokenCount<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor TokenCount<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.TokenCountPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor UnsignedLongNumber(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor UnsignedLongNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor UnsignedLongNumber(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor UnsignedLongNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor UnsignedLongNumber(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor UnsignedLongNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor UnsignedLongNumber<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor UnsignedLongNumber<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Version(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.VersionProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Version<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.VersionProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Version(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Version<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Version(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Version<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Version<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Version<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.VersionPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Wildcard(Elastic.Clients.Elasticsearch.PropertyName key, Elastic.Clients.Elasticsearch.Mapping.WildcardProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Wildcard<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.WildcardProperty value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Wildcard(Elastic.Clients.Elasticsearch.PropertyName key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Wildcard<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Wildcard(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Wildcard<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Wildcard<T>(Elastic.Clients.Elasticsearch.PropertyName key, System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor Wildcard<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<T>>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Mapping.WildcardPropertyDescriptor<T>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.Properties Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.Properties();
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor();
		action.Invoke(builder);
		return builder.Value;
	}
}