// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class OnScriptErrorConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.OnScriptError>
{
	private static readonly System.Text.Json.JsonEncodedText MemberContinue = System.Text.Json.JsonEncodedText.Encode("continue");
	private static readonly System.Text.Json.JsonEncodedText MemberFail = System.Text.Json.JsonEncodedText.Encode("fail");

	public override Elastic.Clients.Elasticsearch.Mapping.OnScriptError Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberContinue))
		{
			return Elastic.Clients.Elasticsearch.Mapping.OnScriptError.Continue;
		}

		if (reader.ValueTextEquals(MemberFail))
		{
			return Elastic.Clients.Elasticsearch.Mapping.OnScriptError.Fail;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberContinue.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.OnScriptError.Continue;
		}

		if (string.Equals(value, MemberFail.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.OnScriptError.Fail;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.OnScriptError)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.OnScriptError value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.OnScriptError.Continue:
				writer.WriteStringValue(MemberContinue);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.OnScriptError.Fail:
				writer.WriteStringValue(MemberFail);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.OnScriptError)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.OnScriptError ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.OnScriptError value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}