// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class IndexOptionsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.IndexOptions>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDocs = System.Text.Json.JsonEncodedText.Encode("docs");
	private static readonly System.Text.Json.JsonEncodedText MemberFreqs = System.Text.Json.JsonEncodedText.Encode("freqs");
	private static readonly System.Text.Json.JsonEncodedText MemberOffsets = System.Text.Json.JsonEncodedText.Encode("offsets");
	private static readonly System.Text.Json.JsonEncodedText MemberPositions = System.Text.Json.JsonEncodedText.Encode("positions");

	public override Elastic.Clients.Elasticsearch.Mapping.IndexOptions Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDocs))
		{
			return Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Docs;
		}

		if (reader.ValueTextEquals(MemberFreqs))
		{
			return Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Freqs;
		}

		if (reader.ValueTextEquals(MemberOffsets))
		{
			return Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Offsets;
		}

		if (reader.ValueTextEquals(MemberPositions))
		{
			return Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Positions;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDocs.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Docs;
		}

		if (string.Equals(value, MemberFreqs.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Freqs;
		}

		if (string.Equals(value, MemberOffsets.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Offsets;
		}

		if (string.Equals(value, MemberPositions.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Positions;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.IndexOptions)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.IndexOptions value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Docs:
				writer.WriteStringValue(MemberDocs);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Freqs:
				writer.WriteStringValue(MemberFreqs);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Offsets:
				writer.WriteStringValue(MemberOffsets);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.IndexOptions.Positions:
				writer.WriteStringValue(MemberPositions);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.IndexOptions)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.IndexOptions ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.IndexOptions value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}