// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class GeoStrategyConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.GeoStrategy>
{
	private static readonly System.Text.Json.JsonEncodedText MemberRecursive = System.Text.Json.JsonEncodedText.Encode("recursive");
	private static readonly System.Text.Json.JsonEncodedText MemberTerm = System.Text.Json.JsonEncodedText.Encode("term");

	public override Elastic.Clients.Elasticsearch.Mapping.GeoStrategy Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberRecursive))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoStrategy.Recursive;
		}

		if (reader.ValueTextEquals(MemberTerm))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoStrategy.Term;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberRecursive.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoStrategy.Recursive;
		}

		if (string.Equals(value, MemberTerm.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoStrategy.Term;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.GeoStrategy)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.GeoStrategy value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.GeoStrategy.Recursive:
				writer.WriteStringValue(MemberRecursive);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.GeoStrategy.Term:
				writer.WriteStringValue(MemberTerm);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.GeoStrategy)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.GeoStrategy ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.GeoStrategy value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}