// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class GeoPointMetricTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCounter = System.Text.Json.JsonEncodedText.Encode("counter");
	private static readonly System.Text.Json.JsonEncodedText MemberGauge = System.Text.Json.JsonEncodedText.Encode("gauge");
	private static readonly System.Text.Json.JsonEncodedText MemberPosition = System.Text.Json.JsonEncodedText.Encode("position");

	public override Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCounter))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Counter;
		}

		if (reader.ValueTextEquals(MemberGauge))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Gauge;
		}

		if (reader.ValueTextEquals(MemberPosition))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Position;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCounter.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Counter;
		}

		if (string.Equals(value, MemberGauge.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Gauge;
		}

		if (string.Equals(value, MemberPosition.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Position;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Counter:
				writer.WriteStringValue(MemberCounter);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Gauge:
				writer.WriteStringValue(MemberGauge);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType.Position:
				writer.WriteStringValue(MemberPosition);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.GeoPointMetricType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}