// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class GeoOrientationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.GeoOrientation>
{
	private static readonly System.Text.Json.JsonEncodedText MemberLeft = System.Text.Json.JsonEncodedText.Encode("left");
	private static readonly System.Text.Json.JsonEncodedText MemberLeft1 = System.Text.Json.JsonEncodedText.Encode("LEFT");
	private static readonly System.Text.Json.JsonEncodedText MemberLeft2 = System.Text.Json.JsonEncodedText.Encode("clockwise");
	private static readonly System.Text.Json.JsonEncodedText MemberLeft3 = System.Text.Json.JsonEncodedText.Encode("cw");
	private static readonly System.Text.Json.JsonEncodedText MemberRight = System.Text.Json.JsonEncodedText.Encode("right");
	private static readonly System.Text.Json.JsonEncodedText MemberRight1 = System.Text.Json.JsonEncodedText.Encode("RIGHT");
	private static readonly System.Text.Json.JsonEncodedText MemberRight2 = System.Text.Json.JsonEncodedText.Encode("counterclockwise");
	private static readonly System.Text.Json.JsonEncodedText MemberRight3 = System.Text.Json.JsonEncodedText.Encode("ccw");

	public override Elastic.Clients.Elasticsearch.Mapping.GeoOrientation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberLeft) || reader.ValueTextEquals(MemberLeft1) || reader.ValueTextEquals(MemberLeft2) || reader.ValueTextEquals(MemberLeft3))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoOrientation.Left;
		}

		if (reader.ValueTextEquals(MemberRight) || reader.ValueTextEquals(MemberRight1) || reader.ValueTextEquals(MemberRight2) || reader.ValueTextEquals(MemberRight3))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoOrientation.Right;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberLeft.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberLeft1.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberLeft2.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberLeft3.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoOrientation.Left;
		}

		if (string.Equals(value, MemberRight.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberRight1.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberRight2.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberRight3.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.GeoOrientation.Right;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.GeoOrientation)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.GeoOrientation value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.GeoOrientation.Left:
				writer.WriteStringValue(MemberLeft);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.GeoOrientation.Right:
				writer.WriteStringValue(MemberRight);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.GeoOrientation)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.GeoOrientation ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.GeoOrientation value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}