// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class FieldTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.FieldType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAggregateMetricDouble = System.Text.Json.JsonEncodedText.Encode("aggregate_metric_double");
	private static readonly System.Text.Json.JsonEncodedText MemberAlias = System.Text.Json.JsonEncodedText.Encode("alias");
	private static readonly System.Text.Json.JsonEncodedText MemberBinary = System.Text.Json.JsonEncodedText.Encode("binary");
	private static readonly System.Text.Json.JsonEncodedText MemberBoolean = System.Text.Json.JsonEncodedText.Encode("boolean");
	private static readonly System.Text.Json.JsonEncodedText MemberByte = System.Text.Json.JsonEncodedText.Encode("byte");
	private static readonly System.Text.Json.JsonEncodedText MemberCompletion = System.Text.Json.JsonEncodedText.Encode("completion");
	private static readonly System.Text.Json.JsonEncodedText MemberConstantKeyword = System.Text.Json.JsonEncodedText.Encode("constant_keyword");
	private static readonly System.Text.Json.JsonEncodedText MemberCountedKeyword = System.Text.Json.JsonEncodedText.Encode("counted_keyword");
	private static readonly System.Text.Json.JsonEncodedText MemberDate = System.Text.Json.JsonEncodedText.Encode("date");
	private static readonly System.Text.Json.JsonEncodedText MemberDateNanos = System.Text.Json.JsonEncodedText.Encode("date_nanos");
	private static readonly System.Text.Json.JsonEncodedText MemberDateRange = System.Text.Json.JsonEncodedText.Encode("date_range");
	private static readonly System.Text.Json.JsonEncodedText MemberDenseVector = System.Text.Json.JsonEncodedText.Encode("dense_vector");
	private static readonly System.Text.Json.JsonEncodedText MemberDouble = System.Text.Json.JsonEncodedText.Encode("double");
	private static readonly System.Text.Json.JsonEncodedText MemberDoubleRange = System.Text.Json.JsonEncodedText.Encode("double_range");
	private static readonly System.Text.Json.JsonEncodedText MemberFlattened = System.Text.Json.JsonEncodedText.Encode("flattened");
	private static readonly System.Text.Json.JsonEncodedText MemberFloat = System.Text.Json.JsonEncodedText.Encode("float");
	private static readonly System.Text.Json.JsonEncodedText MemberFloatRange = System.Text.Json.JsonEncodedText.Encode("float_range");
	private static readonly System.Text.Json.JsonEncodedText MemberGeoPoint = System.Text.Json.JsonEncodedText.Encode("geo_point");
	private static readonly System.Text.Json.JsonEncodedText MemberGeoShape = System.Text.Json.JsonEncodedText.Encode("geo_shape");
	private static readonly System.Text.Json.JsonEncodedText MemberHalfFloat = System.Text.Json.JsonEncodedText.Encode("half_float");
	private static readonly System.Text.Json.JsonEncodedText MemberHistogram = System.Text.Json.JsonEncodedText.Encode("histogram");
	private static readonly System.Text.Json.JsonEncodedText MemberIcuCollationKeyword = System.Text.Json.JsonEncodedText.Encode("icu_collation_keyword");
	private static readonly System.Text.Json.JsonEncodedText MemberInteger = System.Text.Json.JsonEncodedText.Encode("integer");
	private static readonly System.Text.Json.JsonEncodedText MemberIntegerRange = System.Text.Json.JsonEncodedText.Encode("integer_range");
	private static readonly System.Text.Json.JsonEncodedText MemberIp = System.Text.Json.JsonEncodedText.Encode("ip");
	private static readonly System.Text.Json.JsonEncodedText MemberIpRange = System.Text.Json.JsonEncodedText.Encode("ip_range");
	private static readonly System.Text.Json.JsonEncodedText MemberJoin = System.Text.Json.JsonEncodedText.Encode("join");
	private static readonly System.Text.Json.JsonEncodedText MemberKeyword = System.Text.Json.JsonEncodedText.Encode("keyword");
	private static readonly System.Text.Json.JsonEncodedText MemberLong = System.Text.Json.JsonEncodedText.Encode("long");
	private static readonly System.Text.Json.JsonEncodedText MemberLongRange = System.Text.Json.JsonEncodedText.Encode("long_range");
	private static readonly System.Text.Json.JsonEncodedText MemberMatchOnlyText = System.Text.Json.JsonEncodedText.Encode("match_only_text");
	private static readonly System.Text.Json.JsonEncodedText MemberMurmur3 = System.Text.Json.JsonEncodedText.Encode("murmur3");
	private static readonly System.Text.Json.JsonEncodedText MemberNested = System.Text.Json.JsonEncodedText.Encode("nested");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("none");
	private static readonly System.Text.Json.JsonEncodedText MemberObject = System.Text.Json.JsonEncodedText.Encode("object");
	private static readonly System.Text.Json.JsonEncodedText MemberPassthrough = System.Text.Json.JsonEncodedText.Encode("passthrough");
	private static readonly System.Text.Json.JsonEncodedText MemberPercolator = System.Text.Json.JsonEncodedText.Encode("percolator");
	private static readonly System.Text.Json.JsonEncodedText MemberRankFeature = System.Text.Json.JsonEncodedText.Encode("rank_feature");
	private static readonly System.Text.Json.JsonEncodedText MemberRankFeatures = System.Text.Json.JsonEncodedText.Encode("rank_features");
	private static readonly System.Text.Json.JsonEncodedText MemberScaledFloat = System.Text.Json.JsonEncodedText.Encode("scaled_float");
	private static readonly System.Text.Json.JsonEncodedText MemberSearchAsYouType = System.Text.Json.JsonEncodedText.Encode("search_as_you_type");
	private static readonly System.Text.Json.JsonEncodedText MemberSemanticText = System.Text.Json.JsonEncodedText.Encode("semantic_text");
	private static readonly System.Text.Json.JsonEncodedText MemberShape = System.Text.Json.JsonEncodedText.Encode("shape");
	private static readonly System.Text.Json.JsonEncodedText MemberShort = System.Text.Json.JsonEncodedText.Encode("short");
	private static readonly System.Text.Json.JsonEncodedText MemberSparseVector = System.Text.Json.JsonEncodedText.Encode("sparse_vector");
	private static readonly System.Text.Json.JsonEncodedText MemberText = System.Text.Json.JsonEncodedText.Encode("text");
	private static readonly System.Text.Json.JsonEncodedText MemberTokenCount = System.Text.Json.JsonEncodedText.Encode("token_count");
	private static readonly System.Text.Json.JsonEncodedText MemberVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.Mapping.FieldType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAggregateMetricDouble))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.AggregateMetricDouble;
		}

		if (reader.ValueTextEquals(MemberAlias))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Alias;
		}

		if (reader.ValueTextEquals(MemberBinary))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Binary;
		}

		if (reader.ValueTextEquals(MemberBoolean))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Boolean;
		}

		if (reader.ValueTextEquals(MemberByte))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Byte;
		}

		if (reader.ValueTextEquals(MemberCompletion))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Completion;
		}

		if (reader.ValueTextEquals(MemberConstantKeyword))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.ConstantKeyword;
		}

		if (reader.ValueTextEquals(MemberCountedKeyword))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.CountedKeyword;
		}

		if (reader.ValueTextEquals(MemberDate))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Date;
		}

		if (reader.ValueTextEquals(MemberDateNanos))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.DateNanos;
		}

		if (reader.ValueTextEquals(MemberDateRange))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.DateRange;
		}

		if (reader.ValueTextEquals(MemberDenseVector))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.DenseVector;
		}

		if (reader.ValueTextEquals(MemberDouble))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Double;
		}

		if (reader.ValueTextEquals(MemberDoubleRange))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.DoubleRange;
		}

		if (reader.ValueTextEquals(MemberFlattened))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Flattened;
		}

		if (reader.ValueTextEquals(MemberFloat))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Float;
		}

		if (reader.ValueTextEquals(MemberFloatRange))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.FloatRange;
		}

		if (reader.ValueTextEquals(MemberGeoPoint))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.GeoPoint;
		}

		if (reader.ValueTextEquals(MemberGeoShape))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.GeoShape;
		}

		if (reader.ValueTextEquals(MemberHalfFloat))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.HalfFloat;
		}

		if (reader.ValueTextEquals(MemberHistogram))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Histogram;
		}

		if (reader.ValueTextEquals(MemberIcuCollationKeyword))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.IcuCollationKeyword;
		}

		if (reader.ValueTextEquals(MemberInteger))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Integer;
		}

		if (reader.ValueTextEquals(MemberIntegerRange))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.IntegerRange;
		}

		if (reader.ValueTextEquals(MemberIp))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Ip;
		}

		if (reader.ValueTextEquals(MemberIpRange))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.IpRange;
		}

		if (reader.ValueTextEquals(MemberJoin))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Join;
		}

		if (reader.ValueTextEquals(MemberKeyword))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Keyword;
		}

		if (reader.ValueTextEquals(MemberLong))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Long;
		}

		if (reader.ValueTextEquals(MemberLongRange))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.LongRange;
		}

		if (reader.ValueTextEquals(MemberMatchOnlyText))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.MatchOnlyText;
		}

		if (reader.ValueTextEquals(MemberMurmur3))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Murmur3;
		}

		if (reader.ValueTextEquals(MemberNested))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Nested;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.None;
		}

		if (reader.ValueTextEquals(MemberObject))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Object;
		}

		if (reader.ValueTextEquals(MemberPassthrough))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Passthrough;
		}

		if (reader.ValueTextEquals(MemberPercolator))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Percolator;
		}

		if (reader.ValueTextEquals(MemberRankFeature))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.RankFeature;
		}

		if (reader.ValueTextEquals(MemberRankFeatures))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.RankFeatures;
		}

		if (reader.ValueTextEquals(MemberScaledFloat))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.ScaledFloat;
		}

		if (reader.ValueTextEquals(MemberSearchAsYouType))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.SearchAsYouType;
		}

		if (reader.ValueTextEquals(MemberSemanticText))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.SemanticText;
		}

		if (reader.ValueTextEquals(MemberShape))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Shape;
		}

		if (reader.ValueTextEquals(MemberShort))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Short;
		}

		if (reader.ValueTextEquals(MemberSparseVector))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.SparseVector;
		}

		if (reader.ValueTextEquals(MemberText))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Text;
		}

		if (reader.ValueTextEquals(MemberTokenCount))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.TokenCount;
		}

		if (reader.ValueTextEquals(MemberVersion))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Version;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAggregateMetricDouble.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.AggregateMetricDouble;
		}

		if (string.Equals(value, MemberAlias.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Alias;
		}

		if (string.Equals(value, MemberBinary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Binary;
		}

		if (string.Equals(value, MemberBoolean.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Boolean;
		}

		if (string.Equals(value, MemberByte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Byte;
		}

		if (string.Equals(value, MemberCompletion.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Completion;
		}

		if (string.Equals(value, MemberConstantKeyword.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.ConstantKeyword;
		}

		if (string.Equals(value, MemberCountedKeyword.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.CountedKeyword;
		}

		if (string.Equals(value, MemberDate.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Date;
		}

		if (string.Equals(value, MemberDateNanos.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.DateNanos;
		}

		if (string.Equals(value, MemberDateRange.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.DateRange;
		}

		if (string.Equals(value, MemberDenseVector.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.DenseVector;
		}

		if (string.Equals(value, MemberDouble.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Double;
		}

		if (string.Equals(value, MemberDoubleRange.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.DoubleRange;
		}

		if (string.Equals(value, MemberFlattened.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Flattened;
		}

		if (string.Equals(value, MemberFloat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Float;
		}

		if (string.Equals(value, MemberFloatRange.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.FloatRange;
		}

		if (string.Equals(value, MemberGeoPoint.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.GeoPoint;
		}

		if (string.Equals(value, MemberGeoShape.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.GeoShape;
		}

		if (string.Equals(value, MemberHalfFloat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.HalfFloat;
		}

		if (string.Equals(value, MemberHistogram.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Histogram;
		}

		if (string.Equals(value, MemberIcuCollationKeyword.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.IcuCollationKeyword;
		}

		if (string.Equals(value, MemberInteger.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Integer;
		}

		if (string.Equals(value, MemberIntegerRange.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.IntegerRange;
		}

		if (string.Equals(value, MemberIp.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Ip;
		}

		if (string.Equals(value, MemberIpRange.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.IpRange;
		}

		if (string.Equals(value, MemberJoin.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Join;
		}

		if (string.Equals(value, MemberKeyword.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Keyword;
		}

		if (string.Equals(value, MemberLong.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Long;
		}

		if (string.Equals(value, MemberLongRange.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.LongRange;
		}

		if (string.Equals(value, MemberMatchOnlyText.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.MatchOnlyText;
		}

		if (string.Equals(value, MemberMurmur3.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Murmur3;
		}

		if (string.Equals(value, MemberNested.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Nested;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.None;
		}

		if (string.Equals(value, MemberObject.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Object;
		}

		if (string.Equals(value, MemberPassthrough.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Passthrough;
		}

		if (string.Equals(value, MemberPercolator.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Percolator;
		}

		if (string.Equals(value, MemberRankFeature.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.RankFeature;
		}

		if (string.Equals(value, MemberRankFeatures.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.RankFeatures;
		}

		if (string.Equals(value, MemberScaledFloat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.ScaledFloat;
		}

		if (string.Equals(value, MemberSearchAsYouType.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.SearchAsYouType;
		}

		if (string.Equals(value, MemberSemanticText.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.SemanticText;
		}

		if (string.Equals(value, MemberShape.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Shape;
		}

		if (string.Equals(value, MemberShort.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Short;
		}

		if (string.Equals(value, MemberSparseVector.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.SparseVector;
		}

		if (string.Equals(value, MemberText.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Text;
		}

		if (string.Equals(value, MemberTokenCount.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.TokenCount;
		}

		if (string.Equals(value, MemberVersion.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.FieldType.Version;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.FieldType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.FieldType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.AggregateMetricDouble:
				writer.WriteStringValue(MemberAggregateMetricDouble);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Alias:
				writer.WriteStringValue(MemberAlias);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Binary:
				writer.WriteStringValue(MemberBinary);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Boolean:
				writer.WriteStringValue(MemberBoolean);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Byte:
				writer.WriteStringValue(MemberByte);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Completion:
				writer.WriteStringValue(MemberCompletion);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.ConstantKeyword:
				writer.WriteStringValue(MemberConstantKeyword);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.CountedKeyword:
				writer.WriteStringValue(MemberCountedKeyword);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Date:
				writer.WriteStringValue(MemberDate);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.DateNanos:
				writer.WriteStringValue(MemberDateNanos);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.DateRange:
				writer.WriteStringValue(MemberDateRange);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.DenseVector:
				writer.WriteStringValue(MemberDenseVector);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Double:
				writer.WriteStringValue(MemberDouble);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.DoubleRange:
				writer.WriteStringValue(MemberDoubleRange);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Flattened:
				writer.WriteStringValue(MemberFlattened);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Float:
				writer.WriteStringValue(MemberFloat);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.FloatRange:
				writer.WriteStringValue(MemberFloatRange);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.GeoPoint:
				writer.WriteStringValue(MemberGeoPoint);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.GeoShape:
				writer.WriteStringValue(MemberGeoShape);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.HalfFloat:
				writer.WriteStringValue(MemberHalfFloat);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Histogram:
				writer.WriteStringValue(MemberHistogram);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.IcuCollationKeyword:
				writer.WriteStringValue(MemberIcuCollationKeyword);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Integer:
				writer.WriteStringValue(MemberInteger);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.IntegerRange:
				writer.WriteStringValue(MemberIntegerRange);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Ip:
				writer.WriteStringValue(MemberIp);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.IpRange:
				writer.WriteStringValue(MemberIpRange);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Join:
				writer.WriteStringValue(MemberJoin);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Keyword:
				writer.WriteStringValue(MemberKeyword);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Long:
				writer.WriteStringValue(MemberLong);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.LongRange:
				writer.WriteStringValue(MemberLongRange);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.MatchOnlyText:
				writer.WriteStringValue(MemberMatchOnlyText);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Murmur3:
				writer.WriteStringValue(MemberMurmur3);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Nested:
				writer.WriteStringValue(MemberNested);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.None:
				writer.WriteStringValue(MemberNone);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Object:
				writer.WriteStringValue(MemberObject);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Passthrough:
				writer.WriteStringValue(MemberPassthrough);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Percolator:
				writer.WriteStringValue(MemberPercolator);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.RankFeature:
				writer.WriteStringValue(MemberRankFeature);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.RankFeatures:
				writer.WriteStringValue(MemberRankFeatures);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.ScaledFloat:
				writer.WriteStringValue(MemberScaledFloat);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.SearchAsYouType:
				writer.WriteStringValue(MemberSearchAsYouType);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.SemanticText:
				writer.WriteStringValue(MemberSemanticText);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Shape:
				writer.WriteStringValue(MemberShape);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Short:
				writer.WriteStringValue(MemberShort);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.SparseVector:
				writer.WriteStringValue(MemberSparseVector);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Text:
				writer.WriteStringValue(MemberText);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.TokenCount:
				writer.WriteStringValue(MemberTokenCount);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.FieldType.Version:
				writer.WriteStringValue(MemberVersion);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.FieldType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.FieldType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.FieldType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}