// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.DynamicTemplateConverter))]
public sealed partial class DynamicTemplate
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public DynamicTemplate()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DynamicTemplate()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DynamicTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Mapping.IProperty? Mapping { get => GetVariant<Elastic.Clients.Elasticsearch.Mapping.IProperty>("mapping"); set => SetVariant("mapping", value); }
	public Elastic.Clients.Elasticsearch.Mapping.RuntimeField? Runtime { get => GetVariant<Elastic.Clients.Elasticsearch.Mapping.RuntimeField>("runtime"); set => SetVariant("runtime", value); }
	public System.Collections.Generic.ICollection<string>? Match { get; set; }
	public System.Collections.Generic.ICollection<string>? MatchMappingType { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.MatchType? MatchPattern { get; set; }
	public System.Collections.Generic.ICollection<string>? PathMatch { get; set; }
	public System.Collections.Generic.ICollection<string>? PathUnmatch { get; set; }
	public System.Collections.Generic.ICollection<string>? Unmatch { get; set; }
	public System.Collections.Generic.ICollection<string>? UnmatchMappingType { get; set; }

	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DynamicProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.AggregateMetricDoubleProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.FieldAliasProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.BinaryProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.BooleanProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.ByteNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.CompletionProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.ConstantKeywordProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.CountedKeywordProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DateProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DateNanosProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DateRangeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DoubleNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DoubleRangeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.FlattenedProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.FloatNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.FloatRangeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.GeoPointProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.GeoShapeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.HalfFloatNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.HistogramProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.IcuCollationProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.IntegerNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.IntegerRangeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.IpProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.IpRangeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.JoinProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.KeywordProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.LongNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.LongRangeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.MatchOnlyTextProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.Murmur3HashProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.NestedProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.ObjectProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.PassthroughObjectProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.PercolatorProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.PointProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.RankFeatureProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.RankFeaturesProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.RankVectorProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.ScaledFloatNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.SearchAsYouTypeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.SemanticTextProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.ShapeProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.ShortNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.SparseVectorProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.TextProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.TokenCountProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.UnsignedLongNumberProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.VersionProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.WildcardProperty value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Mapping = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.RuntimeField value) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate { Runtime = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct DynamicTemplateDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DynamicTemplateDescriptor(Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DynamicTemplateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate instance) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> Mapping(Elastic.Clients.Elasticsearch.Mapping.IProperty? value)
	{
		Instance.Mapping = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> Mapping(System.Func<Elastic.Clients.Elasticsearch.Mapping.PropertyFactory<TDocument>, Elastic.Clients.Elasticsearch.Mapping.IProperty> action)
	{
		Instance.Mapping = Elastic.Clients.Elasticsearch.Mapping.PropertyFactory<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> Runtime(Elastic.Clients.Elasticsearch.Mapping.RuntimeField? value)
	{
		Instance.Runtime = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> Runtime(System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> Match(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Match = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> Match(params string[] values)
	{
		Instance.Match = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> MatchMappingType(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.MatchMappingType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> MatchMappingType(params string[] values)
	{
		Instance.MatchMappingType = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> MatchPattern(Elastic.Clients.Elasticsearch.Mapping.MatchType? value)
	{
		Instance.MatchPattern = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> PathMatch(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.PathMatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> PathMatch(params string[] values)
	{
		Instance.PathMatch = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> PathUnmatch(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.PathUnmatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> PathUnmatch(params string[] values)
	{
		Instance.PathUnmatch = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> Unmatch(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Unmatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> Unmatch(params string[] values)
	{
		Instance.Unmatch = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> UnmatchMappingType(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.UnmatchMappingType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument> UnmatchMappingType(params string[] values)
	{
		Instance.UnmatchMappingType = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DynamicTemplateDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DynamicTemplateDescriptor(Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DynamicTemplateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor(Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate instance) => new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Mapping(Elastic.Clients.Elasticsearch.Mapping.IProperty? value)
	{
		Instance.Mapping = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Mapping(System.Func<Elastic.Clients.Elasticsearch.Mapping.PropertyFactory, Elastic.Clients.Elasticsearch.Mapping.IProperty> action)
	{
		Instance.Mapping = Elastic.Clients.Elasticsearch.Mapping.PropertyFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Mapping<T>(System.Func<Elastic.Clients.Elasticsearch.Mapping.PropertyFactory<T>, Elastic.Clients.Elasticsearch.Mapping.IProperty> action)
	{
		Instance.Mapping = Elastic.Clients.Elasticsearch.Mapping.PropertyFactory<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Runtime(Elastic.Clients.Elasticsearch.Mapping.RuntimeField? value)
	{
		Instance.Runtime = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Runtime(System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Runtime<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Match(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Match = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Match(params string[] values)
	{
		Instance.Match = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor MatchMappingType(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.MatchMappingType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor MatchMappingType(params string[] values)
	{
		Instance.MatchMappingType = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor MatchPattern(Elastic.Clients.Elasticsearch.Mapping.MatchType? value)
	{
		Instance.MatchPattern = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor PathMatch(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.PathMatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor PathMatch(params string[] values)
	{
		Instance.PathMatch = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor PathUnmatch(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.PathUnmatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor PathUnmatch(params string[] values)
	{
		Instance.PathUnmatch = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Unmatch(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Unmatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor Unmatch(params string[] values)
	{
		Instance.Unmatch = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor UnmatchMappingType(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.UnmatchMappingType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor UnmatchMappingType(params string[] values)
	{
		Instance.UnmatchMappingType = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor(new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}