// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class DynamicTemplateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>
{
	private static readonly System.Text.Json.JsonEncodedText PropMatch = System.Text.Json.JsonEncodedText.Encode("match");
	private static readonly System.Text.Json.JsonEncodedText PropMatchMappingType = System.Text.Json.JsonEncodedText.Encode("match_mapping_type");
	private static readonly System.Text.Json.JsonEncodedText PropMatchPattern = System.Text.Json.JsonEncodedText.Encode("match_pattern");
	private static readonly System.Text.Json.JsonEncodedText PropPathMatch = System.Text.Json.JsonEncodedText.Encode("path_match");
	private static readonly System.Text.Json.JsonEncodedText PropPathUnmatch = System.Text.Json.JsonEncodedText.Encode("path_unmatch");
	private static readonly System.Text.Json.JsonEncodedText PropUnmatch = System.Text.Json.JsonEncodedText.Encode("unmatch");
	private static readonly System.Text.Json.JsonEncodedText PropUnmatchMappingType = System.Text.Json.JsonEncodedText.Encode("unmatch_mapping_type");
	private static readonly System.Text.Json.JsonEncodedText VariantMapping = System.Text.Json.JsonEncodedText.Encode("mapping");
	private static readonly System.Text.Json.JsonEncodedText VariantRuntime = System.Text.Json.JsonEncodedText.Encode("runtime");

	public override Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propMatch = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propMatchMappingType = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Mapping.MatchType?> propMatchPattern = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propPathMatch = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propPathUnmatch = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propUnmatch = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propUnmatchMappingType = default;
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propMatch.TryReadProperty(ref reader, options, PropMatch, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propMatchMappingType.TryReadProperty(ref reader, options, PropMatchMappingType, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propMatchPattern.TryReadProperty(ref reader, options, PropMatchPattern, static Elastic.Clients.Elasticsearch.Mapping.MatchType? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Mapping.MatchType>(o)))
			{
				continue;
			}

			if (propPathMatch.TryReadProperty(ref reader, options, PropPathMatch, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propPathUnmatch.TryReadProperty(ref reader, options, PropPathUnmatch, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propUnmatch.TryReadProperty(ref reader, options, PropUnmatch, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propUnmatchMappingType.TryReadProperty(ref reader, options, PropUnmatchMappingType, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (reader.ValueTextEquals(VariantMapping))
			{
				variantType = VariantMapping.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.IProperty>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRuntime))
			{
				variantType = VariantRuntime.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Mapping.RuntimeField>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant,
			Match = propMatch.Value,
			MatchMappingType = propMatchMappingType.Value,
			MatchPattern = propMatchPattern.Value,
			PathMatch = propPathMatch.Value,
			PathUnmatch = propPathUnmatch.Value,
			Unmatch = propUnmatch.Value,
			UnmatchMappingType = propUnmatchMappingType.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "mapping":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Mapping.IProperty)value.Variant, null, null);
				break;
			case "runtime":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Mapping.RuntimeField)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate)}'.");
		}

		writer.WriteProperty(options, PropMatch, value.Match, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteSingleOrManyCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropMatchMappingType, value.MatchMappingType, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteSingleOrManyCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropMatchPattern, value.MatchPattern, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Mapping.MatchType? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Mapping.MatchType>(o, v));
		writer.WriteProperty(options, PropPathMatch, value.PathMatch, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteSingleOrManyCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropPathUnmatch, value.PathUnmatch, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteSingleOrManyCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropUnmatch, value.Unmatch, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteSingleOrManyCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropUnmatchMappingType, value.UnmatchMappingType, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteSingleOrManyCollectionValue<string>(o, v, null));
		writer.WriteEndObject();
	}
}