// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.DynamicPropertyConverter))]
public sealed partial class DynamicProperty : Elastic.Clients.Elasticsearch.Mapping.IProperty
{
#if NET7_0_OR_GREATER
	public DynamicProperty()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DynamicProperty()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DynamicProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? Analyzer { get; set; }
	public double? Boost { get; set; }
	public bool? Coerce { get; set; }
	public Elastic.Clients.Elasticsearch.Fields? CopyTo { get; set; }
	public bool? DocValues { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? Dynamic { get; set; }
	public bool? EagerGlobalOrdinals { get; set; }
	public bool? Enabled { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Fields { get; set; }
	public string? Format { get; set; }
	public int? IgnoreAbove { get; set; }
	public bool? IgnoreMalformed { get; set; }
	public bool? Index { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.IndexOptions? IndexOptions { get; set; }
	public bool? IndexPhrases { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixes? IndexPrefixes { get; set; }
	public string? Locale { get; set; }

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, string>? Meta { get; set; }
	public bool? Norms { get; set; }
	public Elastic.Clients.Elasticsearch.FieldValue? NullValue { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.OnScriptError? OnScriptError { get; set; }
	public int? PositionIncrementGap { get; set; }
	public int? PrecisionStep { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Properties { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }
	public string? SearchAnalyzer { get; set; }
	public string? SearchQuoteAnalyzer { get; set; }
	public bool? Store { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? SyntheticSourceKeep { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.TermVectorOption? TermVector { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType? TimeSeriesMetric { get; set; }

	public string Type => "{dynamic_type}";
}

public readonly partial struct DynamicPropertyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Mapping.DynamicProperty Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DynamicPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.DynamicProperty instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DynamicPropertyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.DynamicProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Mapping.DynamicProperty instance) => new Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicProperty(Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Boost(double? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Coerce(bool? value = true)
	{
		Instance.Coerce = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> CopyTo(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.CopyTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> CopyTo(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.CopyTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> DocValues(bool? value = true)
	{
		Instance.DocValues = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> EagerGlobalOrdinals(bool? value = true)
	{
		Instance.EagerGlobalOrdinals = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Fields(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> IgnoreAbove(int? value)
	{
		Instance.IgnoreAbove = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> IgnoreMalformed(bool? value = true)
	{
		Instance.IgnoreMalformed = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Index(bool? value = true)
	{
		Instance.Index = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> IndexOptions(Elastic.Clients.Elasticsearch.Mapping.IndexOptions? value)
	{
		Instance.IndexOptions = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> IndexPhrases(bool? value = true)
	{
		Instance.IndexPhrases = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> IndexPrefixes(Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixes? value)
	{
		Instance.IndexPrefixes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> IndexPrefixes()
	{
		Instance.IndexPrefixes = Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixesDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> IndexPrefixes(System.Action<Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixesDescriptor>? action)
	{
		Instance.IndexPrefixes = Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Locale(string? value)
	{
		Instance.Locale = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> AddMeta(string key, string value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Meta.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Norms(bool? value = true)
	{
		Instance.Norms = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> NullValue(Elastic.Clients.Elasticsearch.FieldValue? value)
	{
		Instance.NullValue = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> OnScriptError(Elastic.Clients.Elasticsearch.Mapping.OnScriptError? value)
	{
		Instance.OnScriptError = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> PositionIncrementGap(int? value)
	{
		Instance.PositionIncrementGap = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> PrecisionStep(int? value)
	{
		Instance.PrecisionStep = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> SearchAnalyzer(string? value)
	{
		Instance.SearchAnalyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> SearchQuoteAnalyzer(string? value)
	{
		Instance.SearchQuoteAnalyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> Store(bool? value = true)
	{
		Instance.Store = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> SyntheticSourceKeep(Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? value)
	{
		Instance.SyntheticSourceKeep = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> TermVector(Elastic.Clients.Elasticsearch.Mapping.TermVectorOption? value)
	{
		Instance.TermVector = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument> TimeSeriesMetric(Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType? value)
	{
		Instance.TimeSeriesMetric = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.DynamicProperty Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.DynamicProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Mapping.DynamicProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DynamicPropertyDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.DynamicProperty Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DynamicPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.DynamicProperty instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DynamicPropertyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.DynamicProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.DynamicProperty instance) => new Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DynamicProperty(Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Boost(double? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Coerce(bool? value = true)
	{
		Instance.Coerce = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor CopyTo(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.CopyTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor CopyTo<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.CopyTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor DocValues(bool? value = true)
	{
		Instance.DocValues = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor EagerGlobalOrdinals(bool? value = true)
	{
		Instance.EagerGlobalOrdinals = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Fields(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Fields(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Fields<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor IgnoreAbove(int? value)
	{
		Instance.IgnoreAbove = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor IgnoreMalformed(bool? value = true)
	{
		Instance.IgnoreMalformed = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Index(bool? value = true)
	{
		Instance.Index = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor IndexOptions(Elastic.Clients.Elasticsearch.Mapping.IndexOptions? value)
	{
		Instance.IndexOptions = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor IndexPhrases(bool? value = true)
	{
		Instance.IndexPhrases = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor IndexPrefixes(Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixes? value)
	{
		Instance.IndexPrefixes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor IndexPrefixes()
	{
		Instance.IndexPrefixes = Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixesDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor IndexPrefixes(System.Action<Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixesDescriptor>? action)
	{
		Instance.IndexPrefixes = Elastic.Clients.Elasticsearch.Mapping.TextIndexPrefixesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Locale(string? value)
	{
		Instance.Locale = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Meta(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor AddMeta(string key, string value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Meta.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Norms(bool? value = true)
	{
		Instance.Norms = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor NullValue(Elastic.Clients.Elasticsearch.FieldValue? value)
	{
		Instance.NullValue = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor OnScriptError(Elastic.Clients.Elasticsearch.Mapping.OnScriptError? value)
	{
		Instance.OnScriptError = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor PositionIncrementGap(int? value)
	{
		Instance.PositionIncrementGap = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor PrecisionStep(int? value)
	{
		Instance.PrecisionStep = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Properties<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor SearchAnalyzer(string? value)
	{
		Instance.SearchAnalyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor SearchQuoteAnalyzer(string? value)
	{
		Instance.SearchQuoteAnalyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor Store(bool? value = true)
	{
		Instance.Store = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor SyntheticSourceKeep(Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? value)
	{
		Instance.SyntheticSourceKeep = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor TermVector(Elastic.Clients.Elasticsearch.Mapping.TermVectorOption? value)
	{
		Instance.TermVector = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor TimeSeriesMetric(Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType? value)
	{
		Instance.TimeSeriesMetric = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.DynamicProperty Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.DynamicProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.DynamicPropertyDescriptor(new Elastic.Clients.Elasticsearch.Mapping.DynamicProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}