// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class DynamicMappingConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.DynamicMapping>
{
	private static readonly System.Text.Json.JsonEncodedText MemberFalse = System.Text.Json.JsonEncodedText.Encode("false");
	private static readonly System.Text.Json.JsonEncodedText MemberRuntime = System.Text.Json.JsonEncodedText.Encode("runtime");
	private static readonly System.Text.Json.JsonEncodedText MemberStrict = System.Text.Json.JsonEncodedText.Encode("strict");
	private static readonly System.Text.Json.JsonEncodedText MemberTrue = System.Text.Json.JsonEncodedText.Encode("true");

	public override Elastic.Clients.Elasticsearch.Mapping.DynamicMapping Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberFalse))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.False;
		}

		if (reader.ValueTextEquals(MemberRuntime))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.Runtime;
		}

		if (reader.ValueTextEquals(MemberStrict))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.Strict;
		}

		if (reader.ValueTextEquals(MemberTrue))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.True;
		}

		if (reader.TokenType is not System.Text.Json.JsonTokenType.String)
		{
			throw new System.Text.Json.JsonException($"Unknown member of type '{reader.TokenType}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping)}'.");
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberFalse.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.False;
		}

		if (string.Equals(value, MemberRuntime.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.Runtime;
		}

		if (string.Equals(value, MemberStrict.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.Strict;
		}

		if (string.Equals(value, MemberTrue.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.True;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.DynamicMapping value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.False:
				writer.WriteRawValue(MemberFalse.EncodedUtf8Bytes);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.Runtime:
				writer.WriteStringValue(MemberRuntime);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.Strict:
				writer.WriteStringValue(MemberStrict);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DynamicMapping.True:
				writer.WriteRawValue(MemberTrue.EncodedUtf8Bytes);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.DynamicMapping ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.DynamicMapping value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}