// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.DenseVectorSimilarityConverter))]
public enum DenseVectorSimilarity
{
	/// <summary>
	/// <para>
	/// Computes the cosine similarity. During indexing Elasticsearch automatically normalizes vectors with <c>cosine</c>
	/// similarity to unit length. This allows to internally use <c>dot_product</c> for computing similarity, which is more
	/// efficient. Original un-normalized vectors can be still accessed through scripts.
	/// </para>
	/// <para>
	/// The document <c>_score</c> is computed as <c>(1 + cosine(query, vector)) / 2</c>.
	/// </para>
	/// <para>
	/// The <c>cosine</c> similarity does not allow vectors with zero magnitude, since cosine is not defined in this case.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "cosine")]
	Cosine,
	/// <summary>
	/// <para>
	/// Computes the dot product of two unit vectors. This option provides an optimized way to perform cosine similarity.
	/// The constraints and computed score are defined by <c>element_type</c>.
	/// </para>
	/// <para>
	/// When <c>element_type</c> is <c>float</c>, all vectors must be unit length, including both document and query vectors.
	/// </para>
	/// <para>
	/// The document <c>_score</c> is computed as <c>(1 + dot_product(query, vector)) / 2</c>.
	/// </para>
	/// <para>
	/// When <c>element_type</c> is <c>byte</c>, all vectors must have the same length including both document and query vectors or
	/// results will be inaccurate.
	/// </para>
	/// <para>
	/// The document <c>_score</c> is computed as <c>0.5 + (dot_product(query, vector) / (32768 * dims))</c> where <c>dims</c> is the
	/// number of dimensions per vector.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "dot_product")]
	DotProduct,
	/// <summary>
	/// <para>
	/// Computes similarity based on the <c>L2</c> distance (also known as Euclidean distance) between the vectors.
	/// </para>
	/// <para>
	/// The document <c>_score</c> is computed as <c>1 / (1 + l2_norm(query, vector)^2)</c>.
	/// </para>
	/// <para>
	/// For <c>bit</c> vectors, instead of using <c>l2_norm</c>, the <c>hamming</c> distance between the vectors is used.
	/// </para>
	/// <para>
	/// The <c>_score</c> transformation is <c>(numBits - hamming(a, b)) / numBits</c>.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "l2_norm")]
	L2Norm,
	/// <summary>
	/// <para>
	/// Computes the maximum inner product of two vectors. This is similar to <c>dot_product</c>, but doesn't require vectors
	/// to be normalized. This means that each vector’s magnitude can significantly effect the score.
	/// </para>
	/// <para>
	/// The document <c>_score</c> is adjusted to prevent negative values. For <c>max_inner_product</c> values <c>&lt; 0</c>, the <c>_score</c>
	/// is <c>1 / (1 + -1 * max_inner_product(query, vector))</c>. For non-negative <c>max_inner_product</c> results the <c>_score</c>
	/// is calculated <c>max_inner_product(query, vector) + 1</c>.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "max_inner_product")]
	MaxInnerProduct
}