// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class DenseVectorSimilarityConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCosine = System.Text.Json.JsonEncodedText.Encode("cosine");
	private static readonly System.Text.Json.JsonEncodedText MemberDotProduct = System.Text.Json.JsonEncodedText.Encode("dot_product");
	private static readonly System.Text.Json.JsonEncodedText MemberL2Norm = System.Text.Json.JsonEncodedText.Encode("l2_norm");
	private static readonly System.Text.Json.JsonEncodedText MemberMaxInnerProduct = System.Text.Json.JsonEncodedText.Encode("max_inner_product");

	public override Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCosine))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.Cosine;
		}

		if (reader.ValueTextEquals(MemberDotProduct))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.DotProduct;
		}

		if (reader.ValueTextEquals(MemberL2Norm))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.L2Norm;
		}

		if (reader.ValueTextEquals(MemberMaxInnerProduct))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.MaxInnerProduct;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCosine.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.Cosine;
		}

		if (string.Equals(value, MemberDotProduct.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.DotProduct;
		}

		if (string.Equals(value, MemberL2Norm.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.L2Norm;
		}

		if (string.Equals(value, MemberMaxInnerProduct.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.MaxInnerProduct;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.Cosine:
				writer.WriteStringValue(MemberCosine);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.DotProduct:
				writer.WriteStringValue(MemberDotProduct);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.L2Norm:
				writer.WriteStringValue(MemberL2Norm);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity.MaxInnerProduct:
				writer.WriteStringValue(MemberMaxInnerProduct);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}