// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.DenseVectorPropertyConverter))]
public sealed partial class DenseVectorProperty : Elastic.Clients.Elasticsearch.Mapping.IProperty
{
#if NET7_0_OR_GREATER
	public DenseVectorProperty()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DenseVectorProperty()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DenseVectorProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Number of vector dimensions. Can't exceed <c>4096</c>. If <c>dims</c> is not specified, it will be set to the length of
	/// the first vector added to the field.
	/// </para>
	/// </summary>
	public int? Dims { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? Dynamic { get; set; }

	/// <summary>
	/// <para>
	/// The data type used to encode vectors. The supported data types are <c>float</c> (default), <c>byte</c>, and <c>bit</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorElementType? ElementType { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Fields { get; set; }
	public int? IgnoreAbove { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, you can search this field using the kNN search API.
	/// </para>
	/// </summary>
	public bool? Index { get; set; }

	/// <summary>
	/// <para>
	/// An optional section that configures the kNN indexing algorithm. The HNSW algorithm has two internal parameters
	/// that influence how the data structure is built. These can be adjusted to improve the accuracy of results, at the
	/// expense of slower indexing speed.
	/// </para>
	/// <para>
	/// This parameter can only be specified when <c>index</c> is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions? IndexOptions { get; set; }

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, string>? Meta { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Properties { get; set; }

	/// <summary>
	/// <para>
	/// The vector similarity metric to use in kNN search.
	/// </para>
	/// <para>
	/// Documents are ranked by their vector field's similarity to the query vector. The <c>_score</c> of each document will
	/// be derived from the similarity, in a way that ensures scores are positive and that a larger score corresponds
	/// to a higher ranking.
	/// </para>
	/// <para>
	/// Defaults to <c>l2_norm</c> when <c>element_type</c> is <c>bit</c> otherwise defaults to <c>cosine</c>.
	/// </para>
	/// <para>
	/// <c>bit</c> vectors only support <c>l2_norm</c> as their similarity metric.
	/// </para>
	/// <para>
	/// This parameter can only be specified when <c>index</c> is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity? Similarity { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? SyntheticSourceKeep { get; set; }

	public string Type => "dense_vector";
}

public readonly partial struct DenseVectorPropertyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorPropertyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty instance) => new Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty(Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Number of vector dimensions. Can't exceed <c>4096</c>. If <c>dims</c> is not specified, it will be set to the length of
	/// the first vector added to the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Dims(int? value)
	{
		Instance.Dims = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The data type used to encode vectors. The supported data types are <c>float</c> (default), <c>byte</c>, and <c>bit</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> ElementType(Elastic.Clients.Elasticsearch.Mapping.DenseVectorElementType? value)
	{
		Instance.ElementType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Fields(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> IgnoreAbove(int? value)
	{
		Instance.IgnoreAbove = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, you can search this field using the kNN search API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Index(bool? value = true)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An optional section that configures the kNN indexing algorithm. The HNSW algorithm has two internal parameters
	/// that influence how the data structure is built. These can be adjusted to improve the accuracy of results, at the
	/// expense of slower indexing speed.
	/// </para>
	/// <para>
	/// This parameter can only be specified when <c>index</c> is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> IndexOptions(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions? value)
	{
		Instance.IndexOptions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An optional section that configures the kNN indexing algorithm. The HNSW algorithm has two internal parameters
	/// that influence how the data structure is built. These can be adjusted to improve the accuracy of results, at the
	/// expense of slower indexing speed.
	/// </para>
	/// <para>
	/// This parameter can only be specified when <c>index</c> is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> IndexOptions(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor> action)
	{
		Instance.IndexOptions = Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> AddMeta(string key, string value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Meta.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The vector similarity metric to use in kNN search.
	/// </para>
	/// <para>
	/// Documents are ranked by their vector field's similarity to the query vector. The <c>_score</c> of each document will
	/// be derived from the similarity, in a way that ensures scores are positive and that a larger score corresponds
	/// to a higher ranking.
	/// </para>
	/// <para>
	/// Defaults to <c>l2_norm</c> when <c>element_type</c> is <c>bit</c> otherwise defaults to <c>cosine</c>.
	/// </para>
	/// <para>
	/// <c>bit</c> vectors only support <c>l2_norm</c> as their similarity metric.
	/// </para>
	/// <para>
	/// This parameter can only be specified when <c>index</c> is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> Similarity(Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity? value)
	{
		Instance.Similarity = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument> SyntheticSourceKeep(Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? value)
	{
		Instance.SyntheticSourceKeep = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DenseVectorPropertyDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorPropertyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty instance) => new Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty(Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Number of vector dimensions. Can't exceed <c>4096</c>. If <c>dims</c> is not specified, it will be set to the length of
	/// the first vector added to the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Dims(int? value)
	{
		Instance.Dims = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The data type used to encode vectors. The supported data types are <c>float</c> (default), <c>byte</c>, and <c>bit</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor ElementType(Elastic.Clients.Elasticsearch.Mapping.DenseVectorElementType? value)
	{
		Instance.ElementType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Fields(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Fields(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Fields<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor IgnoreAbove(int? value)
	{
		Instance.IgnoreAbove = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, you can search this field using the kNN search API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Index(bool? value = true)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An optional section that configures the kNN indexing algorithm. The HNSW algorithm has two internal parameters
	/// that influence how the data structure is built. These can be adjusted to improve the accuracy of results, at the
	/// expense of slower indexing speed.
	/// </para>
	/// <para>
	/// This parameter can only be specified when <c>index</c> is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor IndexOptions(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions? value)
	{
		Instance.IndexOptions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An optional section that configures the kNN indexing algorithm. The HNSW algorithm has two internal parameters
	/// that influence how the data structure is built. These can be adjusted to improve the accuracy of results, at the
	/// expense of slower indexing speed.
	/// </para>
	/// <para>
	/// This parameter can only be specified when <c>index</c> is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor IndexOptions(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor> action)
	{
		Instance.IndexOptions = Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Meta(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor AddMeta(string key, string value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Meta.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Properties<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The vector similarity metric to use in kNN search.
	/// </para>
	/// <para>
	/// Documents are ranked by their vector field's similarity to the query vector. The <c>_score</c> of each document will
	/// be derived from the similarity, in a way that ensures scores are positive and that a larger score corresponds
	/// to a higher ranking.
	/// </para>
	/// <para>
	/// Defaults to <c>l2_norm</c> when <c>element_type</c> is <c>bit</c> otherwise defaults to <c>cosine</c>.
	/// </para>
	/// <para>
	/// <c>bit</c> vectors only support <c>l2_norm</c> as their similarity metric.
	/// </para>
	/// <para>
	/// This parameter can only be specified when <c>index</c> is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor Similarity(Elastic.Clients.Elasticsearch.Mapping.DenseVectorSimilarity? value)
	{
		Instance.Similarity = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor SyntheticSourceKeep(Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? value)
	{
		Instance.SyntheticSourceKeep = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.DenseVectorPropertyDescriptor(new Elastic.Clients.Elasticsearch.Mapping.DenseVectorProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}