// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping.Json;

public sealed partial class DenseVectorIndexOptionsTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBbqFlat = System.Text.Json.JsonEncodedText.Encode("bbq_flat");
	private static readonly System.Text.Json.JsonEncodedText MemberBbqHnsw = System.Text.Json.JsonEncodedText.Encode("bbq_hnsw");
	private static readonly System.Text.Json.JsonEncodedText MemberFlat = System.Text.Json.JsonEncodedText.Encode("flat");
	private static readonly System.Text.Json.JsonEncodedText MemberHnsw = System.Text.Json.JsonEncodedText.Encode("hnsw");
	private static readonly System.Text.Json.JsonEncodedText MemberInt4Flat = System.Text.Json.JsonEncodedText.Encode("int4_flat");
	private static readonly System.Text.Json.JsonEncodedText MemberInt4Hnsw = System.Text.Json.JsonEncodedText.Encode("int4_hnsw");
	private static readonly System.Text.Json.JsonEncodedText MemberInt8Flat = System.Text.Json.JsonEncodedText.Encode("int8_flat");
	private static readonly System.Text.Json.JsonEncodedText MemberInt8Hnsw = System.Text.Json.JsonEncodedText.Encode("int8_hnsw");

	public override Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBbqFlat))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.BbqFlat;
		}

		if (reader.ValueTextEquals(MemberBbqHnsw))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.BbqHnsw;
		}

		if (reader.ValueTextEquals(MemberFlat))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Flat;
		}

		if (reader.ValueTextEquals(MemberHnsw))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Hnsw;
		}

		if (reader.ValueTextEquals(MemberInt4Flat))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int4Flat;
		}

		if (reader.ValueTextEquals(MemberInt4Hnsw))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int4Hnsw;
		}

		if (reader.ValueTextEquals(MemberInt8Flat))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int8Flat;
		}

		if (reader.ValueTextEquals(MemberInt8Hnsw))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int8Hnsw;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBbqFlat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.BbqFlat;
		}

		if (string.Equals(value, MemberBbqHnsw.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.BbqHnsw;
		}

		if (string.Equals(value, MemberFlat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Flat;
		}

		if (string.Equals(value, MemberHnsw.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Hnsw;
		}

		if (string.Equals(value, MemberInt4Flat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int4Flat;
		}

		if (string.Equals(value, MemberInt4Hnsw.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int4Hnsw;
		}

		if (string.Equals(value, MemberInt8Flat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int8Flat;
		}

		if (string.Equals(value, MemberInt8Hnsw.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int8Hnsw;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.BbqFlat:
				writer.WriteStringValue(MemberBbqFlat);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.BbqHnsw:
				writer.WriteStringValue(MemberBbqHnsw);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Flat:
				writer.WriteStringValue(MemberFlat);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Hnsw:
				writer.WriteStringValue(MemberHnsw);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int4Flat:
				writer.WriteStringValue(MemberInt4Flat);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int4Hnsw:
				writer.WriteStringValue(MemberInt4Hnsw);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int8Flat:
				writer.WriteStringValue(MemberInt8Flat);
				break;
			case Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType.Int8Hnsw:
				writer.WriteStringValue(MemberInt8Hnsw);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}