// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.DenseVectorIndexOptionsRescoreVectorConverter))]
public sealed partial class DenseVectorIndexOptionsRescoreVector
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorIndexOptionsRescoreVector(float oversample)
	{
		Oversample = oversample;
	}
#if NET7_0_OR_GREATER
	public DenseVectorIndexOptionsRescoreVector()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DenseVectorIndexOptionsRescoreVector()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DenseVectorIndexOptionsRescoreVector(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The oversampling factor to use when searching for the nearest neighbor. This is only applicable to the quantized formats: <c>bbq_*</c>, <c>int4_*</c>, and <c>int8_*</c>.
	/// When provided, <c>oversample * k</c> vectors will be gathered and then their scores will be re-computed with the original vectors.
	/// </para>
	/// <para>
	/// valid values are between <c>1.0</c> and <c>10.0</c> (inclusive), or <c>0</c> exactly to disable oversampling.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	float Oversample { get; set; }
}

public readonly partial struct DenseVectorIndexOptionsRescoreVectorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorIndexOptionsRescoreVectorDescriptor(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorIndexOptionsRescoreVectorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVectorDescriptor(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector instance) => new Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVectorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVectorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The oversampling factor to use when searching for the nearest neighbor. This is only applicable to the quantized formats: <c>bbq_*</c>, <c>int4_*</c>, and <c>int8_*</c>.
	/// When provided, <c>oversample * k</c> vectors will be gathered and then their scores will be re-computed with the original vectors.
	/// </para>
	/// <para>
	/// valid values are between <c>1.0</c> and <c>10.0</c> (inclusive), or <c>0</c> exactly to disable oversampling.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVectorDescriptor Oversample(float value)
	{
		Instance.Oversample = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVectorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVectorDescriptor(new Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}