// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.DenseVectorIndexOptionsConverter))]
public sealed partial class DenseVectorIndexOptions
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorIndexOptions(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType type)
	{
		Type = type;
	}
#if NET7_0_OR_GREATER
	public DenseVectorIndexOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DenseVectorIndexOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DenseVectorIndexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The confidence interval to use when quantizing the vectors. Can be any value between and including <c>0.90</c> and
	/// <c>1.0</c> or exactly <c>0</c>. When the value is <c>0</c>, this indicates that dynamic quantiles should be calculated for
	/// optimized quantization. When between <c>0.90</c> and <c>1.0</c>, this value restricts the values used when calculating
	/// the quantization thresholds.
	/// </para>
	/// <para>
	/// For example, a value of <c>0.95</c> will only use the middle <c>95%</c> of the values when calculating the quantization
	/// thresholds (e.g. the highest and lowest <c>2.5%</c> of values will be ignored).
	/// </para>
	/// <para>
	/// Defaults to <c>1/(dims + 1)</c> for <c>int8</c> quantized vectors and <c>0</c> for <c>int4</c> for dynamic quantile calculation.
	/// </para>
	/// <para>
	/// Only applicable to <c>int8_hnsw</c>, <c>int4_hnsw</c>, <c>int8_flat</c>, and <c>int4_flat</c> index types.
	/// </para>
	/// </summary>
	public float? ConfidenceInterval { get; set; }

	/// <summary>
	/// <para>
	/// The number of candidates to track while assembling the list of nearest neighbors for each new node.
	/// </para>
	/// <para>
	/// Only applicable to <c>hnsw</c>, <c>int8_hnsw</c>, <c>bbq_hnsw</c>, and <c>int4_hnsw</c> index types.
	/// </para>
	/// </summary>
	public int? EfConstruction { get; set; }

	/// <summary>
	/// <para>
	/// The number of neighbors each node will be connected to in the HNSW graph.
	/// </para>
	/// <para>
	/// Only applicable to <c>hnsw</c>, <c>int8_hnsw</c>, <c>bbq_hnsw</c>, and <c>int4_hnsw</c> index types.
	/// </para>
	/// </summary>
	public int? M { get; set; }

	/// <summary>
	/// <para>
	/// The rescore vector options. This is only applicable to <c>bbq_hnsw</c>, <c>int4_hnsw</c>, <c>int8_hnsw</c>, <c>bbq_flat</c>, <c>int4_flat</c>, and <c>int8_flat</c> index types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector? RescoreVector { get; set; }

	/// <summary>
	/// <para>
	/// The type of kNN algorithm to use.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType Type { get; set; }
}

public readonly partial struct DenseVectorIndexOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorIndexOptionsDescriptor(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DenseVectorIndexOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions instance) => new Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The confidence interval to use when quantizing the vectors. Can be any value between and including <c>0.90</c> and
	/// <c>1.0</c> or exactly <c>0</c>. When the value is <c>0</c>, this indicates that dynamic quantiles should be calculated for
	/// optimized quantization. When between <c>0.90</c> and <c>1.0</c>, this value restricts the values used when calculating
	/// the quantization thresholds.
	/// </para>
	/// <para>
	/// For example, a value of <c>0.95</c> will only use the middle <c>95%</c> of the values when calculating the quantization
	/// thresholds (e.g. the highest and lowest <c>2.5%</c> of values will be ignored).
	/// </para>
	/// <para>
	/// Defaults to <c>1/(dims + 1)</c> for <c>int8</c> quantized vectors and <c>0</c> for <c>int4</c> for dynamic quantile calculation.
	/// </para>
	/// <para>
	/// Only applicable to <c>int8_hnsw</c>, <c>int4_hnsw</c>, <c>int8_flat</c>, and <c>int4_flat</c> index types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor ConfidenceInterval(float? value)
	{
		Instance.ConfidenceInterval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of candidates to track while assembling the list of nearest neighbors for each new node.
	/// </para>
	/// <para>
	/// Only applicable to <c>hnsw</c>, <c>int8_hnsw</c>, <c>bbq_hnsw</c>, and <c>int4_hnsw</c> index types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor EfConstruction(int? value)
	{
		Instance.EfConstruction = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of neighbors each node will be connected to in the HNSW graph.
	/// </para>
	/// <para>
	/// Only applicable to <c>hnsw</c>, <c>int8_hnsw</c>, <c>bbq_hnsw</c>, and <c>int4_hnsw</c> index types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor M(int? value)
	{
		Instance.M = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The rescore vector options. This is only applicable to <c>bbq_hnsw</c>, <c>int4_hnsw</c>, <c>int8_hnsw</c>, <c>bbq_flat</c>, <c>int4_flat</c>, and <c>int8_flat</c> index types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor RescoreVector(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVector? value)
	{
		Instance.RescoreVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The rescore vector options. This is only applicable to <c>bbq_hnsw</c>, <c>int4_hnsw</c>, <c>int8_hnsw</c>, <c>bbq_flat</c>, <c>int4_flat</c>, and <c>int8_flat</c> index types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor RescoreVector(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVectorDescriptor> action)
	{
		Instance.RescoreVector = Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsRescoreVectorDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of kNN algorithm to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor Type(Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsType value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptionsDescriptor(new Elastic.Clients.Elasticsearch.Mapping.DenseVectorIndexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}