// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Mapping;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Mapping.Json.CompletionPropertyConverter))]
public sealed partial class CompletionProperty : Elastic.Clients.Elasticsearch.Mapping.IProperty
{
#if NET7_0_OR_GREATER
	public CompletionProperty()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CompletionProperty()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CompletionProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? Analyzer { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Mapping.SuggestContext>? Contexts { get; set; }
	public Elastic.Clients.Elasticsearch.Fields? CopyTo { get; set; }
	public bool? DocValues { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? Dynamic { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Fields { get; set; }
	public int? IgnoreAbove { get; set; }
	public int? MaxInputLength { get; set; }

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, string>? Meta { get; set; }
	public bool? PreservePositionIncrements { get; set; }
	public bool? PreserveSeparators { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Properties { get; set; }
	public string? SearchAnalyzer { get; set; }
	public bool? Store { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? SyntheticSourceKeep { get; set; }

	public string Type => "completion";
}

public readonly partial struct CompletionPropertyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Mapping.CompletionProperty Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.CompletionProperty instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionPropertyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.CompletionProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Mapping.CompletionProperty instance) => new Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.CompletionProperty(Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Contexts(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Mapping.SuggestContext>? value)
	{
		Instance.Contexts = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Contexts(params Elastic.Clients.Elasticsearch.Mapping.SuggestContext[] values)
	{
		Instance.Contexts = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Contexts(params System.Action<Elastic.Clients.Elasticsearch.Mapping.SuggestContextDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Mapping.SuggestContext>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Mapping.SuggestContextDescriptor<TDocument>.Build(action));
		}

		Instance.Contexts = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> CopyTo(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.CopyTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> CopyTo(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.CopyTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> DocValues(bool? value = true)
	{
		Instance.DocValues = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Fields(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> IgnoreAbove(int? value)
	{
		Instance.IgnoreAbove = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> MaxInputLength(int? value)
	{
		Instance.MaxInputLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> AddMeta(string key, string value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Meta.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> PreservePositionIncrements(bool? value = true)
	{
		Instance.PreservePositionIncrements = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> PreserveSeparators(bool? value = true)
	{
		Instance.PreserveSeparators = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> SearchAnalyzer(string? value)
	{
		Instance.SearchAnalyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> Store(bool? value = true)
	{
		Instance.Store = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument> SyntheticSourceKeep(Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? value)
	{
		Instance.SyntheticSourceKeep = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.CompletionProperty Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.CompletionProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Mapping.CompletionProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct CompletionPropertyDescriptor
{
	internal Elastic.Clients.Elasticsearch.Mapping.CompletionProperty Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.CompletionProperty instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionPropertyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Mapping.CompletionProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor(Elastic.Clients.Elasticsearch.Mapping.CompletionProperty instance) => new Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Mapping.CompletionProperty(Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Contexts(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Mapping.SuggestContext>? value)
	{
		Instance.Contexts = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Contexts(params Elastic.Clients.Elasticsearch.Mapping.SuggestContext[] values)
	{
		Instance.Contexts = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Contexts(params System.Action<Elastic.Clients.Elasticsearch.Mapping.SuggestContextDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Mapping.SuggestContext>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Mapping.SuggestContextDescriptor.Build(action));
		}

		Instance.Contexts = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Contexts<T>(params System.Action<Elastic.Clients.Elasticsearch.Mapping.SuggestContextDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Mapping.SuggestContext>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Mapping.SuggestContextDescriptor<T>.Build(action));
		}

		Instance.Contexts = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor CopyTo(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.CopyTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor CopyTo<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.CopyTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor DocValues(bool? value = true)
	{
		Instance.DocValues = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Fields(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Fields(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Fields<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Fields = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor IgnoreAbove(int? value)
	{
		Instance.IgnoreAbove = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor MaxInputLength(int? value)
	{
		Instance.MaxInputLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Meta(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Metadata about the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor AddMeta(string key, string value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Meta.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor PreservePositionIncrements(bool? value = true)
	{
		Instance.PreservePositionIncrements = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor PreserveSeparators(bool? value = true)
	{
		Instance.PreserveSeparators = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Properties<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor SearchAnalyzer(string? value)
	{
		Instance.SearchAnalyzer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor Store(bool? value = true)
	{
		Instance.Store = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor SyntheticSourceKeep(Elastic.Clients.Elasticsearch.Mapping.SyntheticSourceKeepEnum? value)
	{
		Instance.SyntheticSourceKeep = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Mapping.CompletionProperty Build(System.Action<Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Mapping.CompletionProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Mapping.CompletionPropertyDescriptor(new Elastic.Clients.Elasticsearch.Mapping.CompletionProperty(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}