// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

/// <summary>
/// <para>
/// Zero shot classification configuration options
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.ZeroShotClassificationInferenceOptionsConverter))]
public sealed partial class ZeroShotClassificationInferenceOptions
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ZeroShotClassificationInferenceOptions(System.Collections.Generic.ICollection<string> classificationLabels)
	{
		ClassificationLabels = classificationLabels;
	}
#if NET7_0_OR_GREATER
	public ZeroShotClassificationInferenceOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ZeroShotClassificationInferenceOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ZeroShotClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The zero shot classification labels indicating entailment, neutral, and contradiction
	/// Must contain exactly and only entailment, neutral, and contradiction
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> ClassificationLabels { get; set; }

	/// <summary>
	/// <para>
	/// Hypothesis template used when tokenizing labels for prediction
	/// </para>
	/// </summary>
	public string? HypothesisTemplate { get; set; }

	/// <summary>
	/// <para>
	/// The labels to predict.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Labels { get; set; }

	/// <summary>
	/// <para>
	/// Indicates if more than one true label exists.
	/// </para>
	/// </summary>
	public bool? MultiLabel { get; set; }

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public string? ResultsField { get; set; }

	/// <summary>
	/// <para>
	/// The tokenization options to update when inferring
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig? Tokenization { get; set; }
}

/// <summary>
/// <para>
/// Zero shot classification configuration options
/// </para>
/// </summary>
public readonly partial struct ZeroShotClassificationInferenceOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ZeroShotClassificationInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ZeroShotClassificationInferenceOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions(Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The zero shot classification labels indicating entailment, neutral, and contradiction
	/// Must contain exactly and only entailment, neutral, and contradiction
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor ClassificationLabels(System.Collections.Generic.ICollection<string> value)
	{
		Instance.ClassificationLabels = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The zero shot classification labels indicating entailment, neutral, and contradiction
	/// Must contain exactly and only entailment, neutral, and contradiction
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor ClassificationLabels(params string[] values)
	{
		Instance.ClassificationLabels = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Hypothesis template used when tokenizing labels for prediction
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor HypothesisTemplate(string? value)
	{
		Instance.HypothesisTemplate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The labels to predict.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor Labels(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Labels = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The labels to predict.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor Labels(params string[] values)
	{
		Instance.Labels = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates if more than one true label exists.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor MultiLabel(bool? value = true)
	{
		Instance.MultiLabel = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor ResultsField(string? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokenization options to update when inferring
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor Tokenization(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig? value)
	{
		Instance.Tokenization = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokenization options to update when inferring
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor Tokenization(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor> action)
	{
		Instance.Tokenization = Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptionsDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}