// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.XlmRobertaTokenizationConfigConverter))]
public sealed partial class XlmRobertaTokenizationConfig
{
#if NET7_0_OR_GREATER
	public XlmRobertaTokenizationConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public XlmRobertaTokenizationConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal XlmRobertaTokenizationConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Should the tokenizer lower case the text
	/// </para>
	/// </summary>
	public bool? DoLowerCase { get; set; }

	/// <summary>
	/// <para>
	/// Maximum input sequence length for the model
	/// </para>
	/// </summary>
	public int? MaxSequenceLength { get; set; }

	/// <summary>
	/// <para>
	/// Tokenization spanning options. Special value of -1 indicates no spanning takes place
	/// </para>
	/// </summary>
	public int? Span { get; set; }

	/// <summary>
	/// <para>
	/// Should tokenization input be automatically truncated before sending to the model for inference
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationTruncate? Truncate { get; set; }

	/// <summary>
	/// <para>
	/// Is tokenization completed with special tokens
	/// </para>
	/// </summary>
	public bool? WithSpecialTokens { get; set; }
}

public readonly partial struct XlmRobertaTokenizationConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public XlmRobertaTokenizationConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public XlmRobertaTokenizationConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig(Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Should the tokenizer lower case the text
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor DoLowerCase(bool? value = true)
	{
		Instance.DoLowerCase = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum input sequence length for the model
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor MaxSequenceLength(int? value)
	{
		Instance.MaxSequenceLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Tokenization spanning options. Special value of -1 indicates no spanning takes place
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor Span(int? value)
	{
		Instance.Span = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Should tokenization input be automatically truncated before sending to the model for inference
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor Truncate(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationTruncate? value)
	{
		Instance.Truncate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Is tokenization completed with special tokens
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor WithSpecialTokens(bool? value = true)
	{
		Instance.WithSpecialTokens = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}