// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TrainedModelTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberLangIdent = System.Text.Json.JsonEncodedText.Encode("lang_ident");
	private static readonly System.Text.Json.JsonEncodedText MemberPytorch = System.Text.Json.JsonEncodedText.Encode("pytorch");
	private static readonly System.Text.Json.JsonEncodedText MemberTreeEnsemble = System.Text.Json.JsonEncodedText.Encode("tree_ensemble");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberLangIdent))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.LangIdent;
		}

		if (reader.ValueTextEquals(MemberPytorch))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.Pytorch;
		}

		if (reader.ValueTextEquals(MemberTreeEnsemble))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.TreeEnsemble;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberLangIdent.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.LangIdent;
		}

		if (string.Equals(value, MemberPytorch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.Pytorch;
		}

		if (string.Equals(value, MemberTreeEnsemble.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.TreeEnsemble;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.LangIdent:
				writer.WriteStringValue(MemberLangIdent);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.Pytorch:
				writer.WriteStringValue(MemberPytorch);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType.TreeEnsemble:
				writer.WriteStringValue(MemberTreeEnsemble);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}