// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelTreeNodeConverter))]
public sealed partial class TrainedModelTreeNode
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelTreeNode(int nodeIndex)
	{
		NodeIndex = nodeIndex;
	}
#if NET7_0_OR_GREATER
	public TrainedModelTreeNode()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TrainedModelTreeNode()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModelTreeNode(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? DecisionType { get; set; }
	public bool? DefaultLeft { get; set; }
	public double? LeafValue { get; set; }
	public int? LeftChild { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NodeIndex { get; set; }
	public int? RightChild { get; set; }
	public int? SplitFeature { get; set; }
	public int? SplitGain { get; set; }
	public double? Threshold { get; set; }
}

public readonly partial struct TrainedModelTreeNodeDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelTreeNodeDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelTreeNodeDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode instance) => new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor DecisionType(string? value)
	{
		Instance.DecisionType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor DefaultLeft(bool? value = true)
	{
		Instance.DefaultLeft = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor LeafValue(double? value)
	{
		Instance.LeafValue = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor LeftChild(int? value)
	{
		Instance.LeftChild = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor NodeIndex(int value)
	{
		Instance.NodeIndex = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor RightChild(int? value)
	{
		Instance.RightChild = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor SplitFeature(int? value)
	{
		Instance.SplitFeature = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor SplitGain(int? value)
	{
		Instance.SplitGain = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor Threshold(double? value)
	{
		Instance.Threshold = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}